/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training;

import org.encog.cloud.CloudTask;
import org.encog.cloud.EncogCloud;
import org.encog.engine.util.Format;
import org.encog.neural.networks.training.Train;

public class TrainingStatusUtility {
    private long lastUpdate;
    private int iteration;
    private final Train train;
    private final EncogCloud cloud;
    private CloudTask task;

    public TrainingStatusUtility(EncogCloud encogCloud, Train train) {
        this.cloud = encogCloud;
        this.train = train;
        this.lastUpdate = 0L;
        this.iteration = 0;
    }

    public void finish() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Done at iteration #");
        stringBuilder.append(Format.formatInteger(this.iteration));
        stringBuilder.append(" - Error: ");
        stringBuilder.append(Format.formatPercent(this.train.getError()));
        this.task.stop(stringBuilder.toString());
        this.task = null;
    }

    public void update() {
        long l = System.currentTimeMillis();
        long l2 = (l - this.lastUpdate) / 1000L;
        if (this.task == null) {
            this.task = this.cloud.beginTask(this.train.getClass().getSimpleName());
        }
        ++this.iteration;
        if (l2 > 10L) {
            this.lastUpdate = l;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Iteration #");
            stringBuilder.append(Format.formatInteger(this.iteration));
            stringBuilder.append(" - Error: ");
            stringBuilder.append(Format.formatPercent(this.train.getError()));
            this.task.setStatus(stringBuilder.toString());
        }
    }
}

