/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse;

import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.BasicSynapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.WeightedSynapsePersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedSynapse
extends BasicSynapse {
    private static final long serialVersionUID = -1667026867054695646L;
    private Matrix matrix;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public WeightedSynapse() {
    }

    public WeightedSynapse(Layer layer, Layer layer2) {
        this.setFromLayer(layer);
        this.setToLayer(layer2);
        this.matrix = new Matrix(this.getFromNeuronCount(), this.getToNeuronCount());
    }

    public Object clone() {
        WeightedSynapse weightedSynapse = new WeightedSynapse();
        weightedSynapse.setMatrix(this.getMatrix().clone());
        return weightedSynapse;
    }

    public NeuralData compute(NeuralData neuralData) {
        BasicNeuralData basicNeuralData = new BasicNeuralData(this.getToNeuronCount());
        double[] dArray = neuralData.getData();
        double[][] dArray2 = this.getMatrix().getData();
        double[] dArray3 = basicNeuralData.getData();
        for (int i = 0; i < this.getToNeuronCount(); ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d += dArray[j] * dArray2[j][i];
            }
            dArray3[i] = d;
        }
        return basicNeuralData;
    }

    public Persistor createPersistor() {
        return new WeightedSynapsePersistor();
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getMatrixSize() {
        if (this.matrix == null) {
            return 0;
        }
        return this.matrix.size();
    }

    public SynapseType getType() {
        return SynapseType.Weighted;
    }

    public boolean isTeachable() {
        return true;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }
}

