/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.FeedforwardLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRecurrentLogic
extends FeedforwardLogic {
    private static final long serialVersionUID = -7477229575064477961L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SimpleRecurrentLogic.class);

    public void preprocessLayer(Layer layer, NeuralData neuralData, Synapse synapse) {
        for (Synapse synapse2 : this.getNetwork().getStructure().getPreviousSynapses(layer)) {
            NeuralData neuralData2;
            if (synapse2 == synapse) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recurrent layer from: {}", (Object)neuralData);
            }
            if ((neuralData2 = synapse2.getFromLayer().recur()) == null) continue;
            NeuralData neuralData3 = synapse2.compute(neuralData2);
            for (int i = 0; i < neuralData.size(); ++i) {
                neuralData.setData(i, neuralData.getData(i) + neuralData3.getData(i));
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Recurrent layer to: {}", (Object)neuralData);
        }
    }
}

