/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.logic.ThermalLogic;

public class HopfieldLogic
extends ThermalLogic {
    private static final long serialVersionUID = 6522005686471473074L;

    public void addPattern(NeuralData neuralData) {
        Matrix matrix = Matrix.createRowMatrix(neuralData.getData());
        Matrix matrix2 = MatrixMath.transpose(matrix);
        Matrix matrix3 = MatrixMath.multiply(matrix2, matrix);
        Matrix matrix4 = MatrixMath.identity(matrix3.getRows());
        Matrix matrix5 = MatrixMath.subtract(matrix3, matrix4);
        this.convertHopfieldMatrix(matrix5);
    }

    private void convertHopfieldMatrix(Matrix matrix) {
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getRows(); ++j) {
                this.getThermalSynapse().getMatrix().add(i, j, matrix.get(i, j));
            }
        }
    }

    public void run() {
        NeuralData neuralData = this.compute(this.getCurrentState(), null);
        for (int i = 0; i < neuralData.size(); ++i) {
            this.getCurrentState().setData(i, neuralData.getData(i) > 0.0);
        }
    }

    public int runUntilStable(int n) {
        boolean bl = false;
        String string = this.getCurrentState().toString();
        String string2 = this.getCurrentState().toString();
        int n2 = 0;
        do {
            this.run();
            ++n2;
            string = this.getCurrentState().toString();
            if (!string2.equals(string)) {
                if (n2 > n) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            string2 = string;
        } while (!bl);
        return n2;
    }
}

