/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralDataMapping;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.NeuralLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAMLogic
implements NeuralLogic {
    private static final long serialVersionUID = 246153941060562476L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BAMLogic.class);
    private BasicNetwork network;
    private Layer f1Layer;
    private Layer f2Layer;
    private Synapse synapseF1ToF2;
    private Synapse synapseF2ToF1;

    public void addPattern(NeuralData neuralData, NeuralData neuralData2) {
        for (int i = 0; i < this.getF1Neurons(); ++i) {
            for (int j = 0; j < this.getF2Neurons(); ++j) {
                int n = (int)(neuralData.getData(i) * neuralData2.getData(j));
                this.synapseF1ToF2.getMatrix().add(i, j, n);
                this.synapseF2ToF1.getMatrix().add(j, i, n);
            }
        }
    }

    public void clear() {
        this.synapseF1ToF2.getMatrix().clear();
        this.synapseF2ToF1.getMatrix().clear();
    }

    public NeuralData compute(NeuralData neuralData, NeuralOutputHolder neuralOutputHolder) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Compute on BasicNetwork cannot be used, rather call the compute(NeuralData) method on the BAMLogic.");
        }
        throw new NeuralNetworkError("Compute on BasicNetwork cannot be used, rather call the compute(NeuralData) method on the BAMLogic.");
    }

    public NeuralDataMapping compute(NeuralDataMapping neuralDataMapping) {
        boolean bl = true;
        boolean bl2 = true;
        do {
            bl = this.propagateLayer(this.synapseF1ToF2, neuralDataMapping.getFrom(), neuralDataMapping.getTo());
            bl2 = this.propagateLayer(this.synapseF2ToF1, neuralDataMapping.getTo(), neuralDataMapping.getFrom());
        } while (!bl && !bl2);
        return null;
    }

    public int getF1Neurons() {
        return this.f1Layer.getNeuronCount();
    }

    public int getF2Neurons() {
        return this.f2Layer.getNeuronCount();
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    private double getWeight(Synapse synapse, NeuralData neuralData, int n, int n2) {
        if (synapse.getFromNeuronCount() != neuralData.size()) {
            return synapse.getMatrix().get(n, n2);
        }
        return synapse.getMatrix().get(n2, n);
    }

    public void init(BasicNetwork basicNetwork) {
        this.network = basicNetwork;
        this.f1Layer = basicNetwork.getLayer("F1");
        this.f2Layer = basicNetwork.getLayer("F2");
        this.synapseF1ToF2 = basicNetwork.getStructure().findSynapse(this.f1Layer, this.f2Layer, true);
        this.synapseF2ToF1 = basicNetwork.getStructure().findSynapse(this.f2Layer, this.f1Layer, true);
    }

    private boolean propagateLayer(Synapse synapse, NeuralData neuralData, NeuralData neuralData2) {
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < neuralData2.size(); ++i) {
            int n2 = 0;
            for (int j = 0; j < neuralData.size(); ++j) {
                n2 = (int)((double)n2 + this.getWeight(synapse, neuralData, i, j) * neuralData.getData(j));
            }
            if (n2 == 0 || (n = n2 < 0 ? -1 : 1) == (int)neuralData2.getData(i)) continue;
            bl = false;
            neuralData2.setData(i, n);
        }
        return bl;
    }
}

