/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.bipolar.BiPolarNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.ARTLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ART1Logic
extends ARTLogic {
    private static final long serialVersionUID = -8430698735871301528L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ART1Logic.class);
    private Layer layerF1;
    private Layer layerF2;
    private Synapse synapseF1toF2;
    private Synapse synapseF2toF1;
    private int winner;
    private double a1 = 1.0;
    private double b1 = 1.5;
    private double c1 = 5.0;
    private double d1 = 0.9;
    private double l = 3.0;
    private double vigilance = 0.9;
    private boolean[] inhibitF2;
    private int noWinner;
    private BiPolarNeuralData outputF1;
    private BiPolarNeuralData outputF2;

    public void adjustWeights() {
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            if (this.outputF1.getBoolean(i)) {
                double d = this.magnitude(this.outputF1);
                this.synapseF1toF2.getMatrix().set(i, this.winner, 1.0);
                this.synapseF2toF1.getMatrix().set(this.winner, i, this.l / (this.l - 1.0 + d));
                continue;
            }
            this.synapseF1toF2.getMatrix().set(i, this.winner, 0.0);
            this.synapseF2toF1.getMatrix().set(this.winner, i, 0.0);
        }
    }

    public void compute(BiPolarNeuralData biPolarNeuralData, BiPolarNeuralData biPolarNeuralData2) {
        for (int i = 0; i < this.layerF2.getNeuronCount(); ++i) {
            this.inhibitF2[i] = false;
        }
        boolean bl = false;
        boolean bl2 = false;
        do {
            this.setInput(biPolarNeuralData);
            this.computeF2();
            this.getOutput(biPolarNeuralData2);
            if (this.winner != this.noWinner) {
                this.computeF1(biPolarNeuralData);
                double d = this.magnitude(biPolarNeuralData);
                double d2 = this.magnitude(this.outputF1);
                if (d2 / d < this.vigilance) {
                    this.inhibitF2[this.winner] = true;
                    continue;
                }
                bl = true;
                continue;
            }
            bl2 = true;
        } while (!bl && !bl2);
        if (bl) {
            this.adjustWeights();
        }
    }

    public NeuralData compute(NeuralData neuralData, NeuralOutputHolder neuralOutputHolder) {
        if (!(neuralData instanceof BiPolarNeuralData)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Input to ART1 logic network must be BiPolarNeuralData.");
            }
            throw new NeuralNetworkError("Input to ART1 logic network must be BiPolarNeuralData.");
        }
        BiPolarNeuralData biPolarNeuralData = new BiPolarNeuralData(this.layerF1.getNeuronCount());
        this.compute((BiPolarNeuralData)neuralData, biPolarNeuralData);
        return biPolarNeuralData;
    }

    private void computeF1(BiPolarNeuralData biPolarNeuralData) {
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            double d = this.synapseF1toF2.getMatrix().get(i, this.winner) * (double)(this.outputF2.getBoolean(this.winner) ? 1 : 0);
            double d2 = ((double)(biPolarNeuralData.getBoolean(i) ? 1 : 0) + this.d1 * d - this.b1) / (1.0 + this.a1 * ((double)(biPolarNeuralData.getBoolean(i) ? 1 : 0) + this.d1 * d) + this.c1);
            this.outputF1.setData(i, d2 > 0.0);
        }
    }

    private void computeF2() {
        double d = Double.NEGATIVE_INFINITY;
        this.winner = this.noWinner;
        for (int i = 0; i < this.layerF2.getNeuronCount(); ++i) {
            if (!this.inhibitF2[i]) {
                double d2 = 0.0;
                for (int j = 0; j < this.layerF1.getNeuronCount(); ++j) {
                    d2 += this.synapseF2toF1.getMatrix().get(i, j) * (double)(this.outputF1.getBoolean(j) ? 1 : 0);
                }
                if (d2 > d) {
                    d = d2;
                    this.winner = i;
                }
            }
            this.outputF2.setData(i, false);
        }
        if (this.winner != this.noWinner) {
            this.outputF2.setData(this.winner, true);
        }
    }

    public double getA1() {
        return this.a1;
    }

    public double getB1() {
        return this.b1;
    }

    public double getC1() {
        return this.c1;
    }

    public double getD1() {
        return this.d1;
    }

    public double getL() {
        return this.l;
    }

    private void getOutput(BiPolarNeuralData biPolarNeuralData) {
        for (int i = 0; i < this.layerF2.getNeuronCount(); ++i) {
            biPolarNeuralData.setData(i, this.outputF2.getBoolean(i));
        }
    }

    public double getVigilance() {
        return this.vigilance;
    }

    public int getWinner() {
        return this.winner;
    }

    public boolean hasWinner() {
        return this.winner != this.noWinner;
    }

    public void init(BasicNetwork basicNetwork) {
        super.init(basicNetwork);
        this.layerF1 = this.getNetwork().getLayer("F1");
        this.layerF2 = this.getNetwork().getLayer("F2");
        this.inhibitF2 = new boolean[this.layerF2.getNeuronCount()];
        this.synapseF1toF2 = this.getNetwork().getStructure().findSynapse(this.layerF1, this.layerF2, true);
        this.synapseF2toF1 = this.getNetwork().getStructure().findSynapse(this.layerF2, this.layerF1, true);
        this.outputF1 = new BiPolarNeuralData(this.layerF1.getNeuronCount());
        this.outputF2 = new BiPolarNeuralData(this.layerF2.getNeuronCount());
        this.a1 = this.getNetwork().getPropertyDouble("A1");
        this.b1 = this.getNetwork().getPropertyDouble("B1");
        this.c1 = this.getNetwork().getPropertyDouble("C1");
        this.d1 = this.getNetwork().getPropertyDouble("D1");
        this.l = this.getNetwork().getPropertyDouble("L");
        this.vigilance = this.getNetwork().getPropertyDouble("VIGILANCE");
        this.noWinner = this.layerF2.getNeuronCount();
        this.reset();
    }

    public double magnitude(BiPolarNeuralData biPolarNeuralData) {
        double d = 0.0;
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            d += biPolarNeuralData.getBoolean(i) ? 1.0 : 0.0;
        }
        return d;
    }

    public void reset() {
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            for (int j = 0; j < this.layerF2.getNeuronCount(); ++j) {
                this.synapseF1toF2.getMatrix().set(i, j, (this.b1 - 1.0) / this.d1 + 0.2);
                this.synapseF2toF1.getMatrix().set(j, i, this.l / (this.l - 1.0 + (double)this.layerF1.getNeuronCount()) - 0.1);
            }
        }
    }

    public void setA1(double d) {
        this.a1 = d;
    }

    public void setB1(double d) {
        this.b1 = d;
    }

    public void setC1(double d) {
        this.c1 = d;
    }

    public void setD1(double d) {
        this.d1 = d;
    }

    private void setInput(BiPolarNeuralData biPolarNeuralData) {
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            double d = (double)(biPolarNeuralData.getBoolean(i) ? 1 : 0) / (1.0 + this.a1 * ((double)(biPolarNeuralData.getBoolean(i) ? 1 : 0) + this.b1) + this.c1);
            this.outputF1.setData(i, d > 0.0);
        }
    }

    public void setL(double d) {
        this.l = d;
    }

    public void setVigilance(double d) {
        this.vigilance = d;
    }
}

