/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.union;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionNeuralDataSet
implements NeuralDataSet {
    private static final String ADD_ERROR = "Add is not supported in UnionNeuralDataSet";
    private static final String REMOVE_ERROR = "Remove is not supported in UnionNeuralDataSet";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int inputSize;
    private final int idealSize;
    private final List<NeuralDataSet> subsets = new ArrayList<NeuralDataSet>();
    private final Collection<UnionIterator> iterators = new ArrayList<UnionIterator>();

    public UnionNeuralDataSet(int n, int n2) {
        this.inputSize = n;
        this.idealSize = n2;
    }

    @Override
    public void add(NeuralData neuralData) {
        this.logger.error(ADD_ERROR);
        throw new NeuralDataError(ADD_ERROR);
    }

    @Override
    public void add(NeuralData neuralData, NeuralData neuralData2) {
        this.logger.error(ADD_ERROR);
        throw new NeuralDataError(ADD_ERROR);
    }

    @Override
    public void add(NeuralDataPair neuralDataPair) {
        this.logger.error(ADD_ERROR);
        throw new NeuralDataError(ADD_ERROR);
    }

    public void addSubset(NeuralDataSet neuralDataSet) {
        if (neuralDataSet.getInputSize() != this.inputSize) {
            String string = "Subset input size of " + neuralDataSet.getInputSize() + " must match union input size of " + this.inputSize;
            this.logger.error(string);
            throw new NeuralDataError(string);
        }
        if (neuralDataSet.getIdealSize() != this.idealSize) {
            String string = "Subset ideal size of " + neuralDataSet.getIdealSize() + " must match union ideal size of " + this.idealSize;
            this.logger.error(string);
            throw new NeuralDataError(string);
        }
        this.subsets.add(neuralDataSet);
    }

    @Override
    public void close() {
        this.iterators.clear();
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    public List<NeuralDataSet> getSubsets() {
        return this.subsets;
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        UnionIterator unionIterator = new UnionIterator();
        this.iterators.add(unionIterator);
        return unionIterator;
    }

    @Override
    public boolean isSupervised() {
        return this.idealSize > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnionIterator
    implements Iterator<NeuralDataPair> {
        private int currentSet = 1;
        private Iterator<NeuralDataPair> currentIterator;

        public UnionIterator() {
            this.currentIterator = ((NeuralDataSet)UnionNeuralDataSet.this.subsets.get(0)).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext()) {
                if (this.currentSet < UnionNeuralDataSet.this.subsets.size()) {
                    this.currentIterator = ((NeuralDataSet)UnionNeuralDataSet.this.subsets.get(this.currentSet++)).iterator();
                }
                return this.currentIterator.hasNext();
            }
            return true;
        }

        @Override
        public NeuralDataPair next() {
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            UnionNeuralDataSet.this.logger.error(UnionNeuralDataSet.REMOVE_ERROR);
            throw new NeuralDataError(UnionNeuralDataSet.REMOVE_ERROR);
        }
    }
}

