/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.market;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.market.MarketDataDescription;
import org.encog.neural.data.market.MarketError;
import org.encog.neural.data.market.TickerSymbol;
import org.encog.neural.data.market.loader.LoadedMarketData;
import org.encog.neural.data.market.loader.MarketLoader;
import org.encog.neural.data.temporal.TemporalDataDescription;
import org.encog.neural.data.temporal.TemporalNeuralDataSet;
import org.encog.neural.data.temporal.TemporalPoint;
import org.encog.util.time.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketNeuralDataSet
extends TemporalNeuralDataSet {
    private static final long serialVersionUID = 170791819906003867L;
    private final MarketLoader loader;
    private final Map<Integer, TemporalPoint> pointIndex = new HashMap<Integer, TemporalPoint>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MarketNeuralDataSet(MarketLoader marketLoader, int n, int n2) {
        super(n, n2);
        this.loader = marketLoader;
        this.setSequenceGrandularity(TimeUnit.DAYS);
    }

    public void addDescription(TemporalDataDescription temporalDataDescription) {
        if (!(temporalDataDescription instanceof MarketDataDescription)) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Only MarketDataDescription objects may be used with the MarketNeuralDataSet container.");
            }
            throw new MarketError("Only MarketDataDescription objects may be used with the MarketNeuralDataSet container.");
        }
        super.addDescription(temporalDataDescription);
    }

    public TemporalPoint createPoint(Date date) {
        int n = this.getSequenceFromDate(date);
        TemporalPoint temporalPoint = this.pointIndex.get(n);
        if (temporalPoint == null) {
            temporalPoint = super.createPoint(date);
            this.pointIndex.put(temporalPoint.getSequence(), temporalPoint);
        }
        return temporalPoint;
    }

    public NeuralData generateInputForPrediction(Date date) {
        return null;
    }

    public MarketLoader getLoader() {
        return this.loader;
    }

    public void load(Date date, Date date2) {
        if (this.getStartingPoint() == null) {
            this.setStartingPoint(date);
        }
        this.getPoints().clear();
        HashSet<TickerSymbol> hashSet = new HashSet<TickerSymbol>();
        for (TemporalDataDescription object : this.getDescriptions()) {
            MarketDataDescription marketDataDescription = (MarketDataDescription)object;
            hashSet.add(marketDataDescription.getTicker());
        }
        for (TickerSymbol tickerSymbol : hashSet) {
            this.loadSymbol(tickerSymbol, date, date2);
        }
        this.sortPoints();
    }

    private void loadPointFromMarketData(TickerSymbol tickerSymbol, TemporalPoint temporalPoint, LoadedMarketData loadedMarketData) {
        for (TemporalDataDescription temporalDataDescription : this.getDescriptions()) {
            MarketDataDescription marketDataDescription = (MarketDataDescription)temporalDataDescription;
            if (!marketDataDescription.getTicker().equals(tickerSymbol)) continue;
            temporalPoint.setData(marketDataDescription.getIndex(), loadedMarketData.getData(marketDataDescription.getDataType()));
        }
    }

    private void loadSymbol(TickerSymbol tickerSymbol, Date date, Date date2) {
        Collection<LoadedMarketData> collection = this.getLoader().load(tickerSymbol, null, date, date2);
        for (LoadedMarketData loadedMarketData : collection) {
            TemporalPoint temporalPoint = this.createPoint(loadedMarketData.getWhen());
            this.loadPointFromMarketData(tickerSymbol, temporalPoint, loadedMarketData);
        }
    }
}

