/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.image;

import java.awt.Image;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.normalize.output.OutputFieldRangeMapped;
import org.encog.util.downsample.Downsample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageNeuralData
extends BasicNeuralData {
    private static final long serialVersionUID = -4645971270240180450L;
    private Image image;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ImageNeuralData(Image image) {
        super(1);
        this.image = image;
    }

    public void downsample(Downsample downsample, boolean bl, int n, int n2, double d, double d2) {
        if (bl) {
            downsample.findBounds();
        }
        double[] dArray = downsample.downSample(this.image, n, n2);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = OutputFieldRangeMapped.calculate(dArray[i], 0.0, 255.0, d, d2);
        }
        this.setData(dArray);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[ImageNeuralData:");
        for (int i = 0; i < this.getData().length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.getData(i));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

