/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.engine.data.EngineData;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.data.buffer.BufferedDataError;
import org.encog.neural.data.buffer.BufferedDataSetIterator;
import org.encog.neural.data.buffer.EncogEGBFile;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BufferedNeuralDataSetPersistor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedNeuralDataSet
extends BasicPersistedObject
implements NeuralDataSet,
Indexable,
Serializable {
    private static final long serialVersionUID = 2577778772598513566L;
    public static final String ERROR_ADD = "Add can only be used after calling beginLoad.";
    public static final String ERROR_REMOVE = "Remove is not supported for BufferedNeuralDataSet.";
    private transient boolean loading;
    private File file;
    private transient EncogEGBFile egb;
    private transient List<BufferedNeuralDataSet> additional = new ArrayList<BufferedNeuralDataSet>();
    private transient BufferedNeuralDataSet owner;

    public BufferedNeuralDataSet(File file) {
        this.file = file;
        this.egb = new EncogEGBFile(file);
        if (this.file.exists()) {
            this.egb.open();
        }
    }

    public void open() {
        this.egb.open();
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        return new BufferedDataSetIterator(this);
    }

    @Override
    public long getRecordCount() {
        if (this.egb == null) {
            return 0L;
        }
        return this.egb.getNumberOfRecords();
    }

    @Override
    public void getRecord(long l, EngineData engineData) {
        double[] dArray = engineData.getInputArray();
        double[] dArray2 = engineData.getIdealArray();
        this.egb.setLocation((int)l);
        this.egb.read(dArray);
        this.egb.read(dArray2);
    }

    @Override
    public BufferedNeuralDataSet openAdditional() {
        BufferedNeuralDataSet bufferedNeuralDataSet = new BufferedNeuralDataSet(this.file);
        bufferedNeuralDataSet.setOwner(this);
        this.additional.add(bufferedNeuralDataSet);
        return bufferedNeuralDataSet;
    }

    @Override
    public void add(NeuralData neuralData) {
        if (!this.loading) {
            throw new NeuralDataError(ERROR_ADD);
        }
        this.egb.write(neuralData.getData());
    }

    @Override
    public void add(NeuralData neuralData, NeuralData neuralData2) {
        if (!this.loading) {
            throw new NeuralDataError(ERROR_ADD);
        }
        this.egb.write(neuralData.getData());
        this.egb.write(neuralData2.getData());
    }

    @Override
    public void add(NeuralDataPair neuralDataPair) {
        if (!this.loading) {
            throw new NeuralDataError(ERROR_ADD);
        }
        this.egb.write(neuralDataPair.getInputArray());
        this.egb.write(neuralDataPair.getIdealArray());
    }

    @Override
    public void close() {
        Object[] objectArray = this.additional.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            BufferedNeuralDataSet bufferedNeuralDataSet = (BufferedNeuralDataSet)objectArray[i];
            bufferedNeuralDataSet.close();
        }
        this.additional.clear();
        if (this.owner != null) {
            this.owner.removeAdditional(this);
        }
        this.egb.close();
        this.egb = null;
    }

    @Override
    public int getIdealSize() {
        if (this.egb == null) {
            return 0;
        }
        return this.egb.getIdealCount();
    }

    @Override
    public int getInputSize() {
        if (this.egb == null) {
            return 0;
        }
        return this.egb.getInputCount();
    }

    @Override
    public boolean isSupervised() {
        if (this.egb == null) {
            return false;
        }
        return this.egb.getIdealCount() > 0;
    }

    public BufferedNeuralDataSet getOwner() {
        return this.owner;
    }

    public void setOwner(BufferedNeuralDataSet bufferedNeuralDataSet) {
        this.owner = bufferedNeuralDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdditional(BufferedNeuralDataSet bufferedNeuralDataSet) {
        BufferedNeuralDataSet bufferedNeuralDataSet2 = this;
        synchronized (bufferedNeuralDataSet2) {
            this.additional.remove(bufferedNeuralDataSet);
        }
    }

    public void beginLoad(int n, int n2) {
        this.egb.create(n, n2);
        this.loading = true;
    }

    public void endLoad() {
        if (!this.loading) {
            throw new BufferedDataError("Must call beginLoad, before endLoad.");
        }
        this.egb.close();
        this.open();
    }

    @Override
    public Persistor createPersistor() {
        return new BufferedNeuralDataSetPersistor();
    }

    public File getFile() {
        return this.file;
    }

    public EncogEGBFile getEGB() {
        return this.egb;
    }

    public NeuralDataSet loadToMemory() {
        BasicNeuralDataSet basicNeuralDataSet = new BasicNeuralDataSet();
        for (NeuralDataPair neuralDataPair : this) {
            basicNeuralDataSet.add(neuralDataPair);
        }
        return basicNeuralDataSet;
    }

    public void load(NeuralDataSet neuralDataSet) {
        this.beginLoad(neuralDataSet.getInputSize(), neuralDataSet.getIdealSize());
        for (NeuralDataPair neuralDataPair : neuralDataSet) {
            this.add(neuralDataPair);
        }
        this.endLoad();
    }
}

