/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer;

import java.util.Iterator;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.buffer.BufferedNeuralDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedDataSetIterator
implements Iterator<NeuralDataPair> {
    private BufferedNeuralDataSet data;
    private int current;

    public BufferedDataSetIterator(BufferedNeuralDataSet bufferedNeuralDataSet) {
        this.data = bufferedNeuralDataSet;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        return (long)this.current < this.data.getRecordCount();
    }

    @Override
    public NeuralDataPair next() {
        if (!this.hasNext()) {
            return null;
        }
        NeuralDataPair neuralDataPair = BasicNeuralDataPair.createPair(this.data.getInputSize(), this.data.getIdealSize());
        this.data.getRecord(this.current++, neuralDataPair);
        return neuralDataPair;
    }

    @Override
    public void remove() {
        throw new NeuralDataError("Remove is not supported.");
    }
}

