/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.EncogError;
import org.encog.mathutil.randomize.Randomizer;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.synapse.Synapse;

public class NguyenWidrowRandomizer
extends RangeRandomizer
implements Randomizer {
    public NguyenWidrowRandomizer(double d, double d2) {
        super(d, d2);
    }

    public final void randomize(BasicNetwork basicNetwork) {
        Layer layer2;
        super.randomize(basicNetwork);
        int n = 0;
        for (Layer layer2 : basicNetwork.getStructure().getLayers()) {
            n += layer2.getNeuronCount();
        }
        Layer layer3 = basicNetwork.getLayer("INPUT");
        layer2 = basicNetwork.getLayer("OUTPUT");
        if (layer3 == null) {
            throw new EncogError("Must have an input layer for Nguyen-Widrow.");
        }
        if (layer2 == null) {
            throw new EncogError("Must have an output layer for Nguyen-Widrow.");
        }
        int n2 = n - layer3.getNeuronCount() - layer2.getNeuronCount();
        if (n2 < 1) {
            return;
        }
        double d = 0.7 * Math.pow(n2, 1.0 / (double)layer3.getNeuronCount());
        for (Synapse synapse : basicNetwork.getStructure().getSynapses()) {
            this.randomize(d, synapse);
        }
        basicNetwork.getStructure().setFlatUpdate(FlatUpdateNeeded.Flatten);
        basicNetwork.getStructure().flattenWeights();
    }

    private void randomize(double d, Synapse synapse) {
        if (synapse.getMatrix() == null) {
            return;
        }
        for (int i = 0; i < synapse.getToNeuronCount(); ++i) {
            double d2;
            int n;
            double d3 = 0.0;
            for (n = 0; n < synapse.getFromNeuronCount(); ++n) {
                d2 = synapse.getMatrix().get(n, i);
                d3 += d2 * d2;
            }
            if (synapse.getToLayer().hasBias()) {
                double d4 = synapse.getToLayer().getBiasWeight(i);
                d3 += d4 * d4;
                d3 = Math.sqrt(d3);
            }
            for (n = 0; n < synapse.getFromNeuronCount(); ++n) {
                d2 = synapse.getMatrix().get(n, i);
                synapse.getMatrix().set(n, i, d * d2 / d3);
            }
            if (!synapse.getToLayer().hasBias()) continue;
            double d5 = synapse.getToLayer().getBiasWeight(i);
            synapse.getToLayer().setBiasWeight(i, d * d5 / d3);
        }
    }
}

