/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.mathutil.randomize.BasicRandomizer;

public class GaussianRandomizer
extends BasicRandomizer {
    private double y2;
    private boolean useLast = false;
    private final double mean;
    private final double standardDeviation;

    public GaussianRandomizer(double d, double d2) {
        this.mean = d;
        this.standardDeviation = d2;
    }

    public double boxMuller(double d, double d2) {
        double d3;
        if (this.useLast) {
            d3 = this.y2;
            this.useLast = false;
        } else {
            double d4;
            double d5;
            double d6;
            while ((d6 = (d5 = 2.0 * this.nextDouble() - 1.0) * d5 + (d4 = 2.0 * this.nextDouble() - 1.0) * d4) >= 1.0) {
            }
            d6 = Math.sqrt(-2.0 * Math.log(d6) / d6);
            d3 = d5 * d6;
            this.y2 = d4 * d6;
            this.useLast = true;
        }
        return d + d3 * d2;
    }

    public double randomize(double d) {
        return this.boxMuller(this.mean, this.standardDeviation);
    }
}

