/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.decomposition;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;

public class CholeskyDecomposition {
    private double[][] l;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix matrix) {
        double[][] dArray = matrix.getData();
        this.n = matrix.getRows();
        this.l = new double[this.n][this.n];
        this.isspd = matrix.getCols() == this.n;
        for (int i = 0; i < this.n; ++i) {
            int n;
            double[] dArray2 = this.l[i];
            double d = 0.0;
            for (n = 0; n < i; ++n) {
                double[] dArray3 = this.l[n];
                double d2 = 0.0;
                for (int j = 0; j < n; ++j) {
                    d2 += dArray3[j] * dArray2[j];
                }
                dArray2[n] = d2 = (dArray[i][n] - d2) / this.l[n][n];
                d += d2 * d2;
                this.isspd &= dArray[n][i] == dArray[i][n];
            }
            this.isspd &= (d = dArray[i][i] - d) > 0.0;
            this.l[i][i] = Math.sqrt(Math.max(d, 0.0));
            for (n = i + 1; n < this.n; ++n) {
                this.l[i][n] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.l);
    }

    public Matrix solve(Matrix matrix) {
        int n;
        int n2;
        int n3;
        if (matrix.getRows() != this.n) {
            throw new MatrixError("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] dArray = matrix.getArrayCopy();
        int n4 = matrix.getCols();
        for (n3 = 0; n3 < this.n; ++n3) {
            n2 = 0;
            while (n2 < n4) {
                for (n = 0; n < n3; ++n) {
                    double[] dArray2 = dArray[n3];
                    int n5 = n2;
                    dArray2[n5] = dArray2[n5] - dArray[n][n2] * this.l[n3][n];
                }
                double[] dArray3 = dArray[n3];
                int n6 = n2++;
                dArray3[n6] = dArray3[n6] / this.l[n3][n3];
            }
        }
        for (n3 = this.n - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n4) {
                for (n = n3 + 1; n < this.n; ++n) {
                    double[] dArray4 = dArray[n3];
                    int n7 = n2;
                    dArray4[n7] = dArray4[n7] - dArray[n][n2] * this.l[n][n3];
                }
                double[] dArray5 = dArray[n3];
                int n8 = n2++;
                dArray5[n8] = dArray5[n8] / this.l[n3][n3];
            }
        }
        return new Matrix(dArray);
    }
}

