/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MatrixMath {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatrixMath.class);

    public static Matrix add(Matrix matrix, Matrix matrix2) {
        if (matrix.getRows() != matrix2.getRows()) {
            String string = "To add the matrices they must have the same number of rows and columns.  Matrix a has " + matrix.getRows() + " rows and matrix b has " + matrix2.getRows() + " rows.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        if (matrix.getCols() != matrix2.getCols()) {
            String string = "To add the matrices they must have the same number of rows and columns.  Matrix a has " + matrix.getCols() + " cols and matrix b has " + matrix2.getCols() + " cols.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        double[][] dArray = matrix.getData();
        double[][] dArray2 = matrix2.getData();
        double[][] dArray3 = new double[matrix.getRows()][matrix.getCols()];
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                dArray3[i][j] = dArray[i][j] + dArray2[i][j];
            }
        }
        return new Matrix(dArray3);
    }

    public static void copy(Matrix matrix, Matrix matrix2) {
        double[][] dArray = matrix.getData();
        double[][] dArray2 = matrix2.getData();
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
    }

    public static Matrix deleteCol(Matrix matrix, int n) {
        if (n >= matrix.getCols()) {
            String string = "Can't delete column " + n + " from matrix, it only has " + matrix.getCols() + " columns.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        double[][] dArray = new double[matrix.getRows()][matrix.getCols() - 1];
        double[][] dArray2 = matrix.getData();
        for (int i = 0; i < matrix.getRows(); ++i) {
            int n2 = 0;
            for (int j = 0; j < matrix.getCols(); ++j) {
                if (j == n) continue;
                dArray[i][n2] = dArray2[i][j];
                ++n2;
            }
        }
        return new Matrix(dArray);
    }

    public static Matrix deleteRow(Matrix matrix, int n) {
        if (n >= matrix.getRows()) {
            String string = "Can't delete row " + n + " from matrix, it only has " + matrix.getRows() + " rows.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        double[][] dArray = new double[matrix.getRows() - 1][matrix.getCols()];
        double[][] dArray2 = matrix.getData();
        int n2 = 0;
        for (int i = 0; i < matrix.getRows(); ++i) {
            if (i == n) continue;
            for (int j = 0; j < matrix.getCols(); ++j) {
                dArray[n2][j] = dArray2[i][j];
            }
            ++n2;
        }
        return new Matrix(dArray);
    }

    public static Matrix divide(Matrix matrix, double d) {
        double[][] dArray = new double[matrix.getRows()][matrix.getCols()];
        double[][] dArray2 = matrix.getData();
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                dArray[i][j] = dArray2[i][j] / d;
            }
        }
        return new Matrix(dArray);
    }

    public static double dotProduct(Matrix matrix, Matrix matrix2) {
        Double[] doubleArray;
        if (!matrix.isVector() || !matrix2.isVector()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("To take the dot product, both matrices must be vectors.");
            }
            throw new MatrixError("To take the dot product, both matrices must be vectors.");
        }
        Double[] doubleArray2 = matrix.toPackedArray();
        if (doubleArray2.length != (doubleArray = matrix2.toPackedArray()).length) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("To take the dot product, both matrices must be of the same length.");
            }
            throw new MatrixError("To take the dot product, both matrices must be of the same length.");
        }
        double d = 0.0;
        int n = doubleArray2.length;
        for (int i = 0; i < n; ++i) {
            d += doubleArray2[i] * doubleArray[i];
        }
        return d;
    }

    public static Matrix identity(int n) {
        if (n < 1) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Identity matrix must be at least of size 1.");
            }
            throw new MatrixError("Identity matrix must be at least of size 1.");
        }
        Matrix matrix = new Matrix(n, n);
        double[][] dArray = matrix.getData();
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return matrix;
    }

    public static Matrix multiply(Matrix matrix, double d) {
        double[][] dArray = new double[matrix.getRows()][matrix.getCols()];
        double[][] dArray2 = matrix.getData();
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                dArray[i][j] = dArray2[i][j] * d;
            }
        }
        return new Matrix(dArray);
    }

    public static Matrix multiply(Matrix matrix, Matrix matrix2) {
        if (matrix2.getRows() != matrix.getCols()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("To use ordinary matrix multiplication the number of columns on the first matrix must mat the number of rows on the second.");
            }
            throw new MatrixError("To use ordinary matrix multiplication the number of columns on the first matrix must mat the number of rows on the second.");
        }
        double[][] dArray = matrix.getData();
        double[][] dArray2 = matrix2.getData();
        Matrix matrix3 = new Matrix(matrix.getRows(), matrix2.getCols());
        double[][] dArray3 = matrix3.getData();
        double[] dArray4 = new double[matrix.getCols()];
        for (int i = 0; i < matrix2.getCols(); ++i) {
            int n;
            for (n = 0; n < matrix.getCols(); ++n) {
                dArray4[n] = dArray2[n][i];
            }
            for (n = 0; n < matrix.getRows(); ++n) {
                double[] dArray5 = dArray[n];
                double d = 0.0;
                for (int j = 0; j < matrix.getCols(); ++j) {
                    d += dArray5[j] * dArray4[j];
                }
                dArray3[n][i] = d;
            }
        }
        return matrix3;
    }

    public static Matrix subtract(Matrix matrix, Matrix matrix2) {
        if (matrix.getRows() != matrix2.getRows()) {
            String string = "To subtract the matrices they must have the same number of rows and columns.  Matrix a has " + matrix.getRows() + " rows and matrix b has " + matrix2.getRows() + " rows.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        if (matrix.getCols() != matrix2.getCols()) {
            String string = "To subtract the matrices they must have the same number of rows and columns.  Matrix a has " + matrix.getCols() + " cols and matrix b has " + matrix2.getCols() + " cols.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        double[][] dArray = new double[matrix.getRows()][matrix.getCols()];
        double[][] dArray2 = matrix.getData();
        double[][] dArray3 = matrix2.getData();
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                dArray[i][j] = dArray2[i][j] - dArray3[i][j];
            }
        }
        return new Matrix(dArray);
    }

    public static Matrix transpose(Matrix matrix) {
        double[][] dArray = new double[matrix.getCols()][matrix.getRows()];
        double[][] dArray2 = matrix.getData();
        for (int i = 0; i < matrix.getRows(); ++i) {
            for (int j = 0; j < matrix.getCols(); ++j) {
                dArray[j][i] = dArray2[i][j];
            }
        }
        return new Matrix(dArray);
    }

    public static double vectorLength(Matrix matrix) {
        if (!matrix.isVector()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Can only take the vector length of a vector.");
            }
            throw new MatrixError("Can only take the vector length of a vector.");
        }
        Double[] doubleArray = matrix.toPackedArray();
        double d = 0.0;
        for (Double d2 : doubleArray) {
            d += Math.pow(d2, 2.0);
        }
        return Math.sqrt(d);
    }

    private MatrixMath() {
    }
}

