/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.libsvm;

import org.encog.mathutil.libsvm.QMatrix;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_parameter;

abstract class Kernel
extends QMatrix {
    private svm_node[][] x;
    private final double[] x_square;
    private final int kernel_type;
    private final int degree;
    private final double gamma;
    private final double coef0;

    abstract float[] get_Q(int var1, int var2);

    abstract float[] get_QD();

    void swap_index(int n, int n2) {
        svm_node[] svm_nodeArray = this.x[n];
        this.x[n] = this.x[n2];
        this.x[n2] = svm_nodeArray;
        if (this.x_square != null) {
            double d = this.x_square[n];
            this.x_square[n] = this.x_square[n2];
            this.x_square[n2] = d;
        }
    }

    private static double powi(double d, int n) {
        double d2 = d;
        double d3 = 1.0;
        for (int i = n; i > 0; i /= 2) {
            if (i % 2 == 1) {
                d3 *= d2;
            }
            d2 *= d2;
        }
        return d3;
    }

    double kernel_function(int n, int n2) {
        switch (this.kernel_type) {
            case 0: {
                return Kernel.dot(this.x[n], this.x[n2]);
            }
            case 1: {
                return Kernel.powi(this.gamma * Kernel.dot(this.x[n], this.x[n2]) + this.coef0, this.degree);
            }
            case 2: {
                return Math.exp(-this.gamma * (this.x_square[n] + this.x_square[n2] - 2.0 * Kernel.dot(this.x[n], this.x[n2])));
            }
            case 3: {
                return Math.tanh(this.gamma * Kernel.dot(this.x[n], this.x[n2]) + this.coef0);
            }
            case 4: {
                return this.x[n][(int)this.x[n2][0].value].value;
            }
        }
        return 0.0;
    }

    Kernel(int n, svm_node[][] svm_nodeArray, svm_parameter svm_parameter2) {
        this.kernel_type = svm_parameter2.kernel_type;
        this.degree = svm_parameter2.degree;
        this.gamma = svm_parameter2.gamma;
        this.coef0 = svm_parameter2.coef0;
        this.x = (svm_node[][])svm_nodeArray.clone();
        if (this.kernel_type == 2) {
            this.x_square = new double[n];
            for (int i = 0; i < n; ++i) {
                this.x_square[i] = Kernel.dot(this.x[i], this.x[i]);
            }
        } else {
            this.x_square = null;
        }
    }

    static double dot(svm_node[] svm_nodeArray, svm_node[] svm_nodeArray2) {
        double d = 0.0;
        int n = svm_nodeArray.length;
        int n2 = svm_nodeArray2.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            if (svm_nodeArray[n3].index == svm_nodeArray2[n4].index) {
                d += svm_nodeArray[n3++].value * svm_nodeArray2[n4++].value;
                continue;
            }
            if (svm_nodeArray[n3].index > svm_nodeArray2[n4].index) {
                ++n4;
                continue;
            }
            ++n3;
        }
        return d;
    }

    static double k_function(svm_node[] svm_nodeArray, svm_node[] svm_nodeArray2, svm_parameter svm_parameter2) {
        switch (svm_parameter2.kernel_type) {
            case 0: {
                return Kernel.dot(svm_nodeArray, svm_nodeArray2);
            }
            case 1: {
                return Kernel.powi(svm_parameter2.gamma * Kernel.dot(svm_nodeArray, svm_nodeArray2) + svm_parameter2.coef0, svm_parameter2.degree);
            }
            case 2: {
                double d = 0.0;
                int n = svm_nodeArray.length;
                int n2 = svm_nodeArray2.length;
                int n3 = 0;
                int n4 = 0;
                while (n3 < n && n4 < n2) {
                    if (svm_nodeArray[n3].index == svm_nodeArray2[n4].index) {
                        double d2 = svm_nodeArray[n3++].value - svm_nodeArray2[n4++].value;
                        d += d2 * d2;
                        continue;
                    }
                    if (svm_nodeArray[n3].index > svm_nodeArray2[n4].index) {
                        d += svm_nodeArray2[n4].value * svm_nodeArray2[n4].value;
                        ++n4;
                        continue;
                    }
                    d += svm_nodeArray[n3].value * svm_nodeArray[n3].value;
                    ++n3;
                }
                while (n3 < n) {
                    d += svm_nodeArray[n3].value * svm_nodeArray[n3].value;
                    ++n3;
                }
                while (n4 < n2) {
                    d += svm_nodeArray2[n4].value * svm_nodeArray2[n4].value;
                    ++n4;
                }
                return Math.exp(-svm_parameter2.gamma * d);
            }
            case 3: {
                return Math.tanh(svm_parameter2.gamma * Kernel.dot(svm_nodeArray, svm_nodeArray2) + svm_parameter2.coef0);
            }
            case 4: {
                return svm_nodeArray[(int)svm_nodeArray2[0].value].value;
            }
        }
        return 0.0;
    }
}

