/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

public class LinearCongruentialGenerator {
    private final long modulus;
    private final long multiplier;
    private final long increment;
    private long seed;
    public static final long MAX_RAND = 0xFFFFFFFFL;

    public LinearCongruentialGenerator(long l) {
        this((long)Math.pow(2.0, 32.0), 1103515245L, 12345L, l);
    }

    public LinearCongruentialGenerator(long l, long l2, long l3, long l4) {
        this.modulus = l;
        this.multiplier = l2;
        this.increment = l3;
        this.seed = l4;
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getModulus() {
        return this.modulus;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public long getSeed() {
        return this.seed;
    }

    public double nextDouble() {
        return (double)this.nextLong() / 4.294967295E9;
    }

    public long nextLong() {
        this.seed = (this.multiplier * this.seed + this.increment) % this.modulus;
        return this.seed;
    }

    public double range(double d, double d2) {
        double d3 = d2 - d;
        return d3 * this.nextDouble() - d;
    }

    public void setSeed(long l) {
        this.seed = l;
    }
}

