/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

public class Equilateral {
    private final double[][] matrix;

    public Equilateral(int n, double d, double d2) {
        this.matrix = this.equilat(n, d, d2);
    }

    public int decode(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        int n = -1;
        for (int i = 0; i < this.matrix.length; ++i) {
            double d2 = this.getDistance(dArray, i);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public double[] encode(int n) {
        return this.matrix[n];
    }

    private double[][] equilat(int n, double d, double d2) {
        int n2;
        int n3;
        double[][] dArray = new double[n][n - 1];
        dArray[0][0] = -1.0;
        dArray[1][0] = 1.0;
        for (n3 = 2; n3 < n; ++n3) {
            double d3 = n3;
            double d4 = Math.sqrt(d3 * d3 - 1.0) / d3;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = 0;
                while (n4 < n3 - 1) {
                    double[] dArray2 = dArray[n2];
                    int n5 = n4++;
                    dArray2[n5] = dArray2[n5] * d4;
                }
            }
            d3 = -1.0 / d3;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2][n3 - 1] = d3;
            }
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                dArray[n3][n2] = 0.0;
            }
            dArray[n3][n3 - 1] = 1.0;
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            for (n2 = 0; n2 < dArray[0].length; ++n2) {
                dArray[n3][n2] = (dArray[n3][n2] - -1.0) / 2.0 * (d - d2) + d2;
            }
        }
        return dArray;
    }

    public double getDistance(double[] dArray, int n) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.pow(dArray[i] - this.matrix[n][i], 2.0);
        }
        return Math.sqrt(d);
    }
}

