/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationRamp
implements ActivationFunction {
    public static final int PARAM_RAMP_HIGH_THRESHOLD = 0;
    public static final int PARAM_RAMP_LOW_THRESHOLD = 1;
    public static final int PARAM_RAMP_HIGH = 2;
    public static final int PARAM_RAMP_LOW = 3;
    private static final long serialVersionUID = 6336245112244386279L;
    private double[] params = new double[4];

    public ActivationRamp(double d, double d2, double d3, double d4) {
        this.params[0] = d;
        this.params[1] = d2;
        this.params[2] = d3;
        this.params[3] = d4;
    }

    public ActivationRamp() {
        this(1.0, 0.0, 1.0, 0.0);
    }

    public ActivationFunction clone() {
        return new ActivationRamp(this.params[0], this.params[1], this.params[2], this.params[3]);
    }

    public double getHigh() {
        return this.params[2];
    }

    public double getLow() {
        return this.params[3];
    }

    public double getThresholdHigh() {
        return this.params[0];
    }

    public double getThresholdLow() {
        return this.params[1];
    }

    public boolean hasDerivative() {
        return true;
    }

    public void setThresholdLow(double d) {
        this.setParam(1, d);
    }

    public void setThresholdHigh(double d) {
        this.setParam(0, d);
    }

    public void setLow(double d) {
        this.setParam(3, d);
    }

    public void setHigh(double d) {
        this.setParam(2, d);
    }

    public void activationFunction(double[] dArray, int n, int n2) {
        double d = (this.params[0] - this.params[1]) / (this.params[2] - this.params[3]);
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = dArray[i] < this.params[1] ? this.params[3] : (dArray[i] > this.params[0] ? this.params[2] : d * dArray[i]);
        }
    }

    public double derivativeFunction(double d) {
        return 1.0;
    }

    public String[] getParamNames() {
        String[] stringArray = new String[]{"thresholdHigh", "thresholdLow", "high", "low"};
        return stringArray;
    }

    public double[] getParams() {
        return this.params;
    }

    public void setParam(int n, double d) {
        this.params[n] = d;
    }

    public String getOpenCLExpression(boolean bl) {
        return null;
    }
}

