/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.concurrency;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.util.IntRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetermineWorkload {
    public static final int MIN_WORTHWHILE = 100;
    private int threadCount;
    private int workloadSize;

    public DetermineWorkload(int n, int n2) {
        this.workloadSize = n2;
        if (n == 0) {
            long l;
            long l2;
            int n3 = Runtime.getRuntime().availableProcessors();
            if (n3 != 1) {
                ++n3;
            }
            if ((l2 = (l = (long)this.workloadSize) / (long)n3) < 100L) {
                n3 = Math.max(1, (int)(l / 100L));
            }
            this.threadCount = n3;
        } else {
            this.threadCount = Math.min(n, n2);
        }
    }

    public List<IntRange> calculateWorkers() {
        ArrayList<IntRange> arrayList = new ArrayList<IntRange>();
        int n = this.workloadSize / this.threadCount;
        for (int i = 0; i < this.threadCount; ++i) {
            int n2 = i * n;
            int n3 = i == this.threadCount - 1 ? this.workloadSize - 1 : (i + 1) * n - 1;
            arrayList.add(new IntRange(n3, n2));
        }
        return arrayList;
    }

    public int getThreadCount() {
        return this.threadCount;
    }
}

