/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.encog.bot.browse.Address;
import org.encog.bot.browse.BrowseError;
import org.encog.bot.browse.WebPage;
import org.encog.bot.browse.range.Div;
import org.encog.bot.browse.range.DocumentRange;
import org.encog.bot.browse.range.Form;
import org.encog.bot.browse.range.Input;
import org.encog.bot.browse.range.Link;
import org.encog.bot.browse.range.Span;
import org.encog.bot.dataunit.CodeDataUnit;
import org.encog.bot.dataunit.DataUnit;
import org.encog.bot.dataunit.TagDataUnit;
import org.encog.bot.dataunit.TextDataUnit;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadHTML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadWebPage {
    private WebPage page;
    private final URL base;
    private Form lastForm;
    private DocumentRange lastHierarchyElement;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public LoadWebPage(URL uRL) {
        this.base = uRL;
    }

    private void addHierarchyElement(DocumentRange documentRange) {
        if (this.lastHierarchyElement == null) {
            this.page.addContent(documentRange);
        } else {
            this.lastHierarchyElement.addElement(documentRange);
        }
        this.lastHierarchyElement = documentRange;
    }

    private void createCodeDataUnit(String string) {
        if (string.trim().length() > 0) {
            CodeDataUnit codeDataUnit = new CodeDataUnit();
            codeDataUnit.setCode(string);
            this.page.addDataUnit(codeDataUnit);
        }
    }

    private void createTagDataUnit(Tag tag) {
        TagDataUnit tagDataUnit = new TagDataUnit();
        tagDataUnit.setTag(tag.clone());
        this.page.addDataUnit(tagDataUnit);
    }

    private void createTextDataUnit(String string) {
        if (string.trim().length() > 0) {
            TextDataUnit textDataUnit = new TextDataUnit();
            textDataUnit.setText(string);
            this.page.addDataUnit(textDataUnit);
        }
    }

    protected int findEndTag(int n, Tag tag) {
        int n2 = 0;
        for (int i = n; i < this.page.getDataSize(); ++i) {
            DataUnit dataUnit = this.page.getDataUnit(i);
            if (!(dataUnit instanceof TagDataUnit)) continue;
            Tag tag2 = ((TagDataUnit)dataUnit).getTag();
            if (!tag.getName().equalsIgnoreCase(tag2.getName())) continue;
            if (tag2.getType() == Tag.Type.END) {
                if (n2 == 0) {
                    return i;
                }
                --n2;
                continue;
            }
            if (tag2.getType() != Tag.Type.BEGIN) continue;
            ++n2;
        }
        return -1;
    }

    public WebPage load(InputStream inputStream) {
        this.page = new WebPage();
        this.loadDataUnits(inputStream);
        this.loadContents();
        return this.page;
    }

    public WebPage load(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            WebPage webPage = this.load(byteArrayInputStream);
            byteArrayInputStream.close();
            return webPage;
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)iOException);
            }
            throw new BrowseError(iOException);
        }
    }

    protected void loadContents() {
        for (int i = 0; i < this.page.getDataSize(); ++i) {
            DataUnit dataUnit = this.page.getDataUnit(i);
            if (!(dataUnit instanceof TagDataUnit)) continue;
            Tag tag = ((TagDataUnit)dataUnit).getTag();
            if (tag.getType() != Tag.Type.END) {
                if (tag.getName().equalsIgnoreCase("a")) {
                    this.loadLink(i, tag);
                } else if (tag.getName().equalsIgnoreCase("title")) {
                    this.loadTitle(i, tag);
                } else if (tag.getName().equalsIgnoreCase("form")) {
                    this.loadForm(i, tag);
                } else if (tag.getName().equalsIgnoreCase("input")) {
                    this.loadInput(i, tag);
                }
            }
            if (tag.getType() == Tag.Type.BEGIN) {
                if (tag.getName().equalsIgnoreCase("div")) {
                    this.loadDiv(i, tag);
                } else if (tag.getName().equalsIgnoreCase("span")) {
                    this.loadSpan(i, tag);
                }
            }
            if (tag.getType() != Tag.Type.END) continue;
            if (tag.getName().equalsIgnoreCase("div")) {
                if (this.lastHierarchyElement == null) continue;
                this.lastHierarchyElement = this.lastHierarchyElement.getParent();
                continue;
            }
            if (!tag.getName().equalsIgnoreCase("span") || this.lastHierarchyElement == null) continue;
            this.lastHierarchyElement = this.lastHierarchyElement.getParent();
        }
    }

    protected void loadDataUnits(InputStream inputStream) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        ReadHTML readHTML = new ReadHTML(inputStream);
        boolean bl = false;
        boolean bl2 = false;
        while ((n = readHTML.read()) != -1) {
            if (n == 0) {
                if (bl) {
                    this.createCodeDataUnit(stringBuilder.toString());
                } else if (bl2) {
                    this.createCodeDataUnit(stringBuilder.toString());
                } else {
                    this.createTextDataUnit(stringBuilder.toString());
                }
                bl = false;
                bl2 = false;
                stringBuilder.setLength(0);
                this.createTagDataUnit(readHTML.getTag());
                if (readHTML.getTag().getName().equalsIgnoreCase("style")) {
                    bl = true;
                    continue;
                }
                if (!readHTML.getTag().getName().equalsIgnoreCase("script")) continue;
                bl2 = true;
                continue;
            }
            stringBuilder.append((char)n);
        }
        this.createTextDataUnit(stringBuilder.toString());
    }

    private void loadDiv(int n, Tag tag) {
        Div div = new Div(this.page);
        String string = tag.getAttributeValue("class");
        String string2 = tag.getAttributeValue("id");
        div.setIdAttribute(string2);
        div.setClassAttribute(string);
        div.setBegin(n);
        div.setEnd(this.findEndTag(n + 1, tag));
        this.addHierarchyElement(div);
    }

    protected void loadForm(int n, Tag tag) {
        String string = tag.getAttributeValue("method");
        String string2 = tag.getAttributeValue("action");
        Form form = new Form(this.page);
        form.setBegin(n);
        form.setEnd(this.findEndTag(n + 1, tag));
        if (string == null || string.equalsIgnoreCase("GET")) {
            form.setMethod(Form.Method.GET);
        } else {
            form.setMethod(Form.Method.POST);
        }
        if (string2 == null) {
            form.setAction(new Address(this.base));
        } else {
            form.setAction(new Address(this.base, string2));
        }
        this.page.addContent(form);
        this.lastForm = form;
    }

    protected void loadInput(int n, Tag tag) {
        String string = tag.getAttributeValue("type");
        String string2 = tag.getAttributeValue("name");
        String string3 = tag.getAttributeValue("value");
        Input input = new Input(this.page);
        input.setType(string);
        input.setName(string2);
        input.setValue(string3);
        if (this.lastForm != null) {
            this.lastForm.addElement(input);
        } else {
            this.page.addContent(input);
        }
    }

    protected void loadLink(int n, Tag tag) {
        Link link = new Link(this.page);
        String string = tag.getAttributeValue("href");
        if (string != null) {
            link.setTarget(new Address(this.base, string));
            link.setBegin(n);
            link.setEnd(this.findEndTag(n + 1, tag));
            this.page.addContent(link);
        }
    }

    private void loadSpan(int n, Tag tag) {
        Span span = new Span(this.page);
        String string = tag.getAttributeValue("class");
        String string2 = tag.getAttributeValue("id");
        span.setIdAttribute(string2);
        span.setClassAttribute(string);
        span.setBegin(n);
        span.setEnd(this.findEndTag(n + 1, tag));
        this.addHierarchyElement(span);
    }

    protected void loadTitle(int n, Tag tag) {
        DocumentRange documentRange = new DocumentRange(this.page);
        documentRange.setBegin(n);
        documentRange.setEnd(this.findEndTag(n + 1, tag));
        this.page.setTitle(documentRange);
    }
}

