/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins;

import jams.io.BufferedFileReader;
import jams.workspace.DataReader;
import jams.workspace.DefaultDataSet;
import jams.workspace.Workspace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class J2KTSFileReader
implements DataReader {
    private String dataFileName;
    private transient BufferedFileReader reader;

    public int init() {
        int result;
        File file = new File(this.dataFileName);
        if (file.exists()) {
            try {
                this.reader = new BufferedFileReader(new FileInputStream(file));
                result = 0;
            }
            catch (IOException ioe) {
                System.err.println("J2KTSFileReader: " + ioe);
                result = -1;
            }
        } else {
            result = -2;
        }
        return result;
    }

    public DataReader.ReaderType getReaderType() {
        return DataReader.ReaderType.Empty;
    }

    public int cleanup() {
        int result = 0;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                System.err.println("J2KTSFileReader: " + ioe);
                result = -1;
            }
        }
        return result;
    }

    public DefaultDataSet getMetadata(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int fetchValues() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int fetchValues(int count) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DefaultDataSet[] getData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int numberOfColumns() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public void setWorkspace(Workspace ws) throws IOException {
        File file = new File(this.dataFileName);
        File file2 = new File(ws.getInputDirectory(), file.getName());
        long p = this.reader.getPosition();
        this.dataFileName = file2.getAbsolutePath();
        this.init();
        this.reader.setPosition(p);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeLong(this.reader.getPosition());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        long position = in.readLong();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.init();
        this.reader.setPosition(position);
    }
}

