/*
 * Decompiled with CFR 0.152.
 */
package jams.components.unit;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;

public class SpecificHumidityToRelativeHumidity
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="specific humidity", unit="kg / kg")
    public Attribute.Double specHum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="mean daily temperature", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="relative humidity", unit="%")
    public Attribute.Double relHum;

    public void run() {
        double s = this.specHum.getValue();
        double p = 1013.0;
        double T = this.tmean.getValue();
        double es = 611.0 * Math.exp(17.67 * T / (T + 273.15 - 29.65));
        double ws = 0.622 * es / (100.0 * p);
        double r = 100.0 * s / ws;
        this.relHum.setValue(r);
    }
}

