/*
 * Decompiled with CFR 0.152.
 */
package jams.components.unit;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Converts clt into sunh", author="Christian Fischer", date="1. December 2010", description=" Bug for cloud cover fixed (old: sunh = maxSunh * cloudCoverFraction * 0.01  ;new: sunh = maxSunh * (1 - (cloudCoverFraction * 0.01))")
public class CloudCoverToSunshineDuration
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="fraction of cloud cover in parts", unit="%")
    public Attribute.Double cloudCoverFraction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Maximum sunshine duration in h", unit="h/d")
    public Attribute.Double maxSunh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="sunshine duration in h", unit="h/d")
    public Attribute.Double sunh;

    public void run() {
        this.sunh.setValue(this.maxSunh.getValue() * (1.0 - this.cloudCoverFraction.getValue() * 0.01));
    }
}

