/*
 * Decompiled with CFR 0.152.
 */
package jams.components.tools;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;

@JAMSComponentDescription(title="JScience Unit Converter", author="Sven Kralisch", date="1. December 2005", description="This component converts an input value having a certain unit into an output value having another unit. The units are represented by SI compliant unit strings, e.g. m^3/s.")
public class JAMSUnitConverter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Unit of input value")
    public Attribute.String inUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Unit of output value")
    public Attribute.String outUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Input value")
    public Attribute.Double[] inValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Output value")
    public Attribute.Double[] outValue;
    transient Unit in;
    transient Unit out;
    transient UnitConverter conv;

    public void init() {
        Locale l = new Locale.Builder().setLanguage("en").setRegion("US").build();
        try {
            this.in = UnitFormat.getInstance((Locale)l).parseProductUnit((CharSequence)this.inUnit.getValue(), new ParsePosition(0));
            this.out = UnitFormat.getInstance((Locale)l).parseProductUnit((CharSequence)this.outUnit.getValue(), new ParsePosition(0));
            if (!this.in.isCompatible(this.out)) {
                this.getModel().getRuntime().sendHalt("Incompatible units: " + this.inUnit + " <-> " + this.outUnit);
            }
            this.conv = this.in.getConverterTo(this.out);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
    }

    public void run() {
        for (int i = 0; i < this.inValue.length; ++i) {
            this.outValue[i].setValue(this.conv.convert(this.inValue[i].getValue()));
        }
    }

    private void readObject(ObjectInputStream objStream) throws IOException, ClassNotFoundException {
        objStream.defaultReadObject();
        this.in = Unit.valueOf((CharSequence)this.inUnit.getValue());
        this.out = Unit.valueOf((CharSequence)this.outUnit.getValue());
        this.conv = this.in.getConverterTo(this.out);
    }
}

