/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import jams.components.machineLearning.ActivationFunction;
import jams.components.machineLearning.Matrix;
import jams.components.machineLearning.Regression;

public class Polynom
implements ActivationFunction {
    private double[] params;

    public Polynom(double[] a) {
        this.params = a;
    }

    public Polynom(Matrix M, int degree) {
        try {
            this.params = this.getParams(M, degree);
        }
        catch (Exception e) {
            double[] dummy = new double[]{0.0, 1.0};
            this.params = dummy;
        }
    }

    public Polynom() {
        this.params = new double[2];
        this.params[0] = 0.0;
        this.params[1] = 1.0;
    }

    @Override
    public double calculate(double x) {
        double result = 0.0;
        for (int i = 0; i < this.params.length; ++i) {
            result += this.params[i] * Math.pow(x, i);
        }
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public String getDescription() {
        return "";
    }

    public String getDescription2() {
        String result = Double.toString(this.params[0]);
        for (int i = 1; i < this.params.length; ++i) {
            result = result + " + " + this.params[i] + "*x^" + i;
        }
        return result;
    }

    private double[] getParams(Matrix D, int degree) throws Exception {
        return Regression.getPolyParams(D, degree);
    }

    @Override
    public ActivationFunction derive() {
        double[] a = new double[this.params.length - 1];
        Polynom drv = new Polynom(a);
        for (int i = 1; i < this.params.length; ++i) {
            drv.params[i - 1] = (double)i * this.params[i];
        }
        return drv;
    }

    @Override
    public int getType() {
        return 1;
    }
}

