/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io.unidata;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.object.h4.H4File;
import ncsa.hdf.object.h4.H4SDS;

@JAMSComponentDescription(title="JAMS spatial context", author="Christian Fischer", date="2014-01-17", version="1.1_0", description="This component reads data from MOD16 HDF files")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2014-01-17", comment="Initial version"), @VersionComments.Entry(version="1.1_0", date="2015-08-03", comment="Fixed 0.1 bug, i.e. all pixel values are multiplied with 0.1 now (http://www.ntsg.umt.edu/project/mod16#documentation)")})
public class HDFReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the actual time step")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="scheme for naming of hdf files e.g. MOD16A2.A%year%M%month%.*")
    public Attribute.String namingScheme;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="value of missing data", defaultValue="-9999")
    public Attribute.Double missingDataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="col of pixel")
    public Attribute.DoubleArray cols;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="row of pixel")
    public Attribute.DoubleArray rows;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="row of pixel")
    public Attribute.DoubleArray weights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="name of dataset to read from")
    public Attribute.String datafield;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="value of pixel")
    public Attribute.Double value;
    short[] actData = null;
    int width = -1;
    Attribute.Calendar lastTimeStep = null;
    DecimalFormat format = new DecimalFormat("00");

    private void openNextFile(String name, String dataset, Attribute.Calendar time) {
        name = name.replace("%year%", Integer.toString(time.get(1)));
        name = name.replace("%month%", Integer.toString(time.get(2) + 1));
        name = name.replace("%Month%", this.format.format(time.get(2) + 1));
        name = name.replace("%day%", Integer.toString(time.get(5)));
        name = name.replace("%Day%", this.format.format(time.get(5)));
        name = name.replace("%hour%", Integer.toString(time.get(11)));
        name = name.replace("%Hour%", this.format.format(time.get(11)));
        int i1 = name.lastIndexOf("/");
        int i2 = name.lastIndexOf("\\");
        i1 = Math.max(i1, i2);
        File dir = this.getModel().getWorkspaceDirectory();
        String regex = name;
        if (i1 != -1) {
            String subDir = name.substring(0, i1);
            dir = new File(dir, subDir);
            regex = name.substring(i1 + 1);
        }
        File candidate = null;
        for (File f : dir.listFiles()) {
            if (!f.getName().matches(regex)) continue;
            if (candidate != null) {
                this.getModel().getRuntime().sendInfoMsg("Error in HDFReader: There are multiple files for time step " + time.toString() + "\nPossible candidates are:" + candidate.getName() + "\nand\n" + f.getName());
            }
            candidate = f;
        }
        if (candidate == null) {
            this.getModel().getRuntime().sendInfoMsg("Error in HDFReader: There is no matching file for time step " + time.toString());
            this.actData = null;
            return;
        }
        this.readDataset(candidate, dataset);
    }

    public void run() {
        if (this.lastTimeStep == null || this.lastTimeStep.getTimeInMillis() != this.time.getTimeInMillis()) {
            this.openNextFile(this.namingScheme.getValue(), this.datafield.getValue(), this.time);
            this.lastTimeStep = this.time.clone();
        }
        double[] colArray = this.cols.getValue();
        double[] rowArray = this.rows.getValue();
        double[] wArray = this.weights.getValue();
        int v = 0;
        for (int i = 0; i < colArray.length; ++i) {
            v = (int)((double)v + wArray[i] * this.getValue((int)colArray[i], (int)rowArray[i]) * 0.1);
        }
        this.value.setValue((double)v);
    }

    public static void main(String[] args) {
        HDFReader reader = new HDFReader();
        reader.readDataset(new File("Y:/TFO/data/Spatial_Data/Modis_MOD16/408/h19v10_teil1/Y2001/M02/MOD16A2.A2001M02.h19v10.105.2013120140547.hdf"), "ET_1km");
    }

    private boolean getData(TreeNode node, String id) throws HDFException {
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            H4SDS sds;
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)node.getChildAt(i);
            if (node2.getUserObject() instanceof H4SDS && (sds = (H4SDS)node2.getUserObject()).getName().equals(id)) {
                this.actData = (short[])sds.read();
                this.width = sds.getWidth();
                return true;
            }
            if (!this.getData(node2, id)) continue;
            return true;
        }
        return false;
    }

    private double getValue(int x, int y) {
        if (this.actData == null) {
            return JAMS.getMissingDataValue();
        }
        double v = this.actData[y * this.width + x];
        if (v >= 20000.0) {
            return 0.0;
        }
        return v;
    }

    private void readDataset(File f, String dataset) {
        H4File h4file = new H4File(f.getAbsolutePath(), HDF5Constants.H5F_ACC_RDONLY);
        try {
            h4file.open();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TreeNode root = h4file.getRootNode();
        if (root != null) {
            try {
                boolean success = this.getData(root, dataset);
                if (!success) {
                    this.getModel().getRuntime().sendInfoMsg("Error in HDFReader. Could not find dataset " + dataset + " in file: " + f.getName());
                    this.actData = null;
                }
            }
            catch (HDFException ex) {
                ex.printStackTrace();
                this.getModel().getRuntime().sendInfoMsg("Error in HDFReader during read of file " + f.getName());
                this.actData = null;
            }
        }
        try {
            h4file.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

