/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.components.aggregate.SpatialOutputDataStore;
import jams.data.AbstractDataSupplier;
import jams.data.Attribute;
import jams.data.DataSupplier;
import jams.io.ShapeFileOutputDataStore;
import jams.io.SimpleOutputDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.tools.FileTools;
import jams.tools.StringTools;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;

@JAMSComponentDescription(title="TemporalShapeEntityWriter", author="Christian Fischer", description="Reads a source shape file containing geometries features that match a given EntityCollection. Running in a time loop, this component creates a new Shapefile for each given attribute containing the old geometries and a single entity attribute value at certain time steps.", date="2023-02-10", version="1.0_4")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2006-09-18", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2017-06-21", comment="Fixed descriptions"), @VersionComments.Entry(version="1.0_2", date="2018-09-10", comment="Fixed bug with non-existing folder when using persistent output"), @VersionComments.Entry(version="1.0_3", date="2022-05-11", comment="Output behaviour changed such that subdirectories are created at \"_\""), @VersionComments.Entry(version="1.0_4", date="2023-02-10", comment="Output shapefile can now be renamed to a defined base name plus output attribute")})
public class TemporalShapeEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Defines of attributes are considered or not. One value per attribute.")
    public Attribute.Boolean[] isEnabled;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the source Shapefile, relative to workspace")
    public Attribute.String srcShapeFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Rename the target Shapefile?", defaultValue="true")
    public Attribute.Boolean renameShapeFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Base name of the target Shapefile", defaultValue="")
    public Attribute.String destShapeFileBase;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of ID attribute in the Shapefile")
    public Attribute.String idName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Names of attributes to be created")
    public Attribute.String[] attributeNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attributes to be output")
    public Attribute.String[] attributes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current model time", defaultValue="1970-01-01 00:00")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Custom number of hrus to filter", defaultValue="")
    public Attribute.String idFilters;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity collection to be used as input")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Clean up the tmp dir?", defaultValue="true")
    public Attribute.Boolean cleanup;
    SimpleOutputDataStore[] outData = null;
    SpatialOutputDataStore[] outData2 = null;
    File dbfFileOriginal = null;
    ShapeFileOutputDataStore[] shpStore = null;
    HashSet<Double> selectedIds = null;
    String path;
    boolean isHeaderWritten = false;
    boolean writeShape = false;
    Attribute.Calendar lastTimeStep = null;
    int n = 0;
    EntityDataProvider[] entityDataProviders;

    protected boolean isIDSelected(double id) {
        if (!this.idFilters.getValue().isEmpty()) {
            String[] idFilter;
            if (this.selectedIds != null) {
                return this.selectedIds.contains(id);
            }
            this.selectedIds = new HashSet();
            for (String filter : idFilter = this.idFilters.getValue().split(";")) {
                try {
                    if (filter.contains("[")) {
                        String[] ids = filter.split("-");
                        ids[0] = ids[0].replace("[", "");
                        ids[0] = ids[0].replace("]", "");
                        ids[1] = ids[1].replace("[", "");
                        ids[1] = ids[1].replace("]", "");
                        double id1 = Double.parseDouble(ids[1]);
                        for (double id0 = Double.parseDouble(ids[0]); id0 <= id1; id0 += 1.0) {
                            this.selectedIds.add(id0);
                        }
                        continue;
                    }
                    double idF = Double.parseDouble(filter);
                    this.selectedIds.add(idF);
                }
                catch (Throwable nfe) {
                    this.getModel().getRuntime().sendErrorMsg("Error: Could not parse filter string:" + filter);
                    return false;
                }
            }
            return this.selectedIds.contains(id);
        }
        return true;
    }

    public void init() {
        this.n = this.attributes.length;
        this.isHeaderWritten = false;
        this.outData = new SimpleOutputDataStore[this.n];
        this.outData2 = new SpatialOutputDataStore[this.n];
        this.shpStore = new ShapeFileOutputDataStore[this.n];
        this.entityDataProviders = new EntityDataProvider[this.n];
        this.writeShape = this.srcShapeFile != null;
        this.path = this.getModel().getWorkspace().getOutputDataDirectory().getAbsolutePath();
        for (String dir : this.getInstanceName().split("_")) {
            this.path = this.path + "/" + dir.replace(" ", "_");
        }
        if (this.renameShapeFile.getValue()) {
            TemporalShapeEntityWriter.deleteDirectory(new File(this.path));
        }
        for (int i = 0; i < this.n; ++i) {
            if (!this.isEnabled[i].getValue()) continue;
            String fileName = this.attributeNames[i].getValue();
            File f = new File(FileTools.createAbsoluteFileName((String)this.path, (String)("_tmp/" + fileName + ".dat")));
            File f2 = new File(FileTools.createAbsoluteFileName((String)this.path, (String)(fileName + ".dat")));
            this.entityDataProviders[i] = new EntityDataProvider(this.attributes[i].getValue(), this.entities);
            try {
                f.getParentFile().mkdirs();
                f2.getParentFile().mkdirs();
                if (this.writeShape) {
                    this.outData[i] = new SimpleOutputDataStore(f, false);
                }
                this.outData2[i] = new SpatialOutputDataStore(f2);
            }
            catch (IOException ioe) {
                this.getModel().getRuntime().sendHalt("Can't write to output file: " + f);
            }
            if (!this.writeShape) continue;
            File originalShpFile = new File(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspacePath(), (String)this.srcShapeFile.getValue()));
            File newDBFFile = new File(this.path + "/" + fileName);
            newDBFFile.mkdirs();
            try {
                this.shpStore[i] = new ShapeFileOutputDataStore(originalShpFile, newDBFFile);
                continue;
            }
            catch (IOException ioe) {
                this.getModel().getRuntime().sendErrorMsg(MessageFormat.format(ioe.toString(), this.getInstanceName()));
            }
        }
    }

    public void run() {
        if (this.time.getTimeInMillis() == -10000000000L) {
            return;
        }
        if (this.lastTimeStep != null && this.time.getTimeInMillis() == this.lastTimeStep.getTimeInMillis()) {
            return;
        }
        this.lastTimeStep = this.time.getValue();
        try {
            for (int i = 0; i < this.n; ++i) {
                if (!this.isEnabled[i].getValue()) continue;
                if (!this.isHeaderWritten) {
                    ArrayList<Double> ids = new ArrayList<Double>();
                    for (int j = 0; j < this.entities.getEntities().size(); ++j) {
                        double iid = ((Attribute.Entity)this.entities.getEntities().get(j)).getId();
                        if (!this.isIDSelected(iid)) {
                            return;
                        }
                        ids.add(iid);
                    }
                    if (this.writeShape) {
                        this.outData[i].setHeader(ids);
                    }
                    this.outData2[i].setHeader(ids);
                }
                if (this.writeShape) {
                    this.outData[i].writeData(this.time.toString(), (DataSupplier)this.entityDataProviders[i]);
                }
                this.outData2[i].writeData(this.time.toString(), (DataSupplier<Double>)this.entityDataProviders[i]);
            }
            this.isHeaderWritten = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void cleanup() {
        int i;
        if (this.writeShape) {
            for (i = 0; i < this.n; ++i) {
                if (!this.isEnabled[i].getValue()) continue;
                this.getModel().getRuntime().sendInfoMsg("Transfering data to shapefile from dataset: " + this.outData[i].getFile().getName());
                try {
                    this.shpStore[i].addDataToShpFiles(this.outData[i], this.idName.getValue());
                    continue;
                }
                catch (IOException ioe) {
                    this.getModel().getRuntime().sendHalt("Can't write to output file:" + this.outData[i].getFile() + "\n" + ioe.toString());
                }
            }
        }
        try {
            for (i = 0; i < this.n; ++i) {
                if (!this.isEnabled[i].getValue()) continue;
                if (this.writeShape) {
                    this.outData[i].close();
                    if (this.renameShapeFile.getValue()) {
                        this.renameShape(this.shpStore[i].getTargetDirectory(), this.attributeNames[i].getValue());
                    }
                }
                this.outData2[i].close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (this.cleanup.getValue()) {
            File f = new File(FileTools.createAbsoluteFileName((String)this.path, (String)"_tmp/"));
            TemporalShapeEntityWriter.deleteDirectory(f);
        }
    }

    void renameShape(File directory, String name) {
        for (File srcFile : directory.listFiles()) {
            try {
                String fileName = srcFile.getName();
                int index = fileName.lastIndexOf(".");
                String baseName = this.destShapeFileBase.getValue();
                if (StringTools.isEmptyString((String)baseName)) {
                    baseName = fileName.substring(0, index);
                }
                fileName = name.concat(fileName.substring(index));
                fileName = baseName.concat("_" + fileName);
                Path dest = Paths.get(srcFile.getParent() + "/" + fileName, new String[0]);
                Path src = Paths.get(srcFile.getAbsolutePath(), new String[0]);
                Files.move(src, dest, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ioe) {
                this.getModel().getRuntime().sendErrorMsg(ioe.toString());
            }
        }
    }

    public static void deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    TemporalShapeEntityWriter.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        directory.delete();
    }

    boolean deleteDirectory_(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                TemporalShapeEntityWriter.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    private class EntityDataProvider
    extends AbstractDataSupplier<Double, Attribute.EntityCollection> {
        String name;

        public EntityDataProvider(String name, Attribute.EntityCollection input) {
            super((Object)input);
            this.name = "";
            this.name = name;
        }

        public int size() {
            return ((Attribute.EntityCollection)this.input).getEntities().size();
        }

        public Double get(int i) {
            return ((Attribute.Entity)((Attribute.EntityCollection)this.input).getEntities().get(i)).getDouble(this.name);
        }
    }
}

