/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="TSColumnToEntityValue", author="Sven Kralisch", description="Take a line from from an input datastore as input and extract one value matching a single entity. The proper value is identified by matching the entity ID (or any other unique attribute) with the datastore columns ID.", date="2014-06-20", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2014-06-20", comment="Initial version")})
public class TSColumnToEntityValue
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of double values from a datastore. Order according to datastore")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of column IDs")
    public Attribute.StringArray columnID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The entity's ID to match with the column ID")
    public Attribute.Double entityID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="The position of the entity's value within the data array (written once at the beginning and read afterwards")
    public Attribute.Integer columnNumber;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The entity's value extracted from the data array")
    public Attribute.Double dataValue;
    private double[] _columnID;

    public void init() {
        this._columnID = new double[this.columnID.getValue().length];
        int i = 0;
        for (String s : this.columnID.getValue()) {
            this._columnID[i++] = Double.parseDouble(s);
        }
    }

    public void initAll() {
        this.columnNumber.setValue(-1);
        for (int i = 0; i < this._columnID.length; ++i) {
            if (this.entityID.getValue() != this._columnID[i]) continue;
            this.columnNumber.setValue(i);
        }
    }

    public void run() {
        int i = this.columnNumber.getValue();
        if (i >= 0) {
            this.dataValue.setValue(this.dataArray.getValue()[i]);
        }
    }
}

