/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.AbstractDataSupplier;
import jams.data.Attribute;
import jams.data.NamedDataSupplier;
import jams.io.ShapeFileOutputDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;

@JAMSComponentDescription(title="ShapeEntityReader", author="Sven Kralisch", description="Reads a shape file and creates a list of JAMS entities containing an entity for each feature. An attribute name must be provided in order to identify the id field used in the shape file")
public class ShapeEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the shape file")
    public Attribute.Boolean[] isEnabled;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the shape file")
    public Attribute.String srcShapeFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of identifying attribute in shape file")
    public Attribute.String idName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="names of attributes to be created")
    public Attribute.String[] attributeNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="names of attributes to be created")
    public Attribute.String[] attributes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="custom number of hrus to filter", defaultValue="")
    public Attribute.String idFilters;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Entity collection to be created")
    public Attribute.EntityCollection entities;
    File dbfFileOriginal = null;
    ShapeFileOutputDataStore shpStore = null;
    HashSet<Double> selectedIds = null;
    int n = 0;
    NamedEntityDataProvider[] entityDataProviders;

    protected boolean isIDSelected(double id) {
        if (!this.idFilters.getValue().isEmpty()) {
            String[] idFilter;
            if (this.selectedIds != null) {
                return this.selectedIds.contains(id);
            }
            this.selectedIds = new HashSet();
            for (String filter : idFilter = this.idFilters.getValue().split(";")) {
                try {
                    if (filter.contains("[")) {
                        String[] ids = filter.split("-");
                        ids[0] = ids[0].replace("[", "");
                        ids[0] = ids[0].replace("]", "");
                        ids[1] = ids[1].replace("[", "");
                        ids[1] = ids[1].replace("]", "");
                        double id1 = Double.parseDouble(ids[1]);
                        for (double id0 = Double.parseDouble(ids[0]); id0 <= id1; id0 += 1.0) {
                            this.selectedIds.add(id0);
                        }
                        continue;
                    }
                    double idF = Double.parseDouble(filter);
                    this.selectedIds.add(idF);
                }
                catch (Throwable nfe) {
                    this.getModel().getRuntime().sendErrorMsg("Error: Could not parse filter string:" + filter);
                    return false;
                }
            }
            return this.selectedIds.contains(id);
        }
        return true;
    }

    public void init() {
        this.n = this.attributeNames.length;
        this.entityDataProviders = new NamedEntityDataProvider[this.n];
        String path = this.getModel().getWorkspace().getOutputDataDirectory().getAbsolutePath();
        String fileName = this.getInstanceName();
        File originalShpFile = new File(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspacePath(), (String)this.srcShapeFile.getValue()));
        File newDBFFile = new File(path + "/" + fileName);
        newDBFFile.mkdirs();
        try {
            this.shpStore = new ShapeFileOutputDataStore(originalShpFile, newDBFFile);
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().sendErrorMsg(MessageFormat.format(ioe.toString(), this.getInstanceName()));
        }
        for (int i = 0; i < this.n; ++i) {
            if (!this.isEnabled[i].getValue()) continue;
            this.entityDataProviders[i] = new NamedEntityDataProvider(this.entities, this.attributes[i].getValue());
        }
    }

    public void cleanup() {
        this.getModel().getRuntime().sendInfoMsg("Write shapefile to: " + this.shpStore.getTargetDirectory());
        try {
            this.shpStore.addDataToShpFiles((NamedDataSupplier[])this.entityDataProviders, this.idName.getValue());
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().sendHalt("Can't write to output file.");
            ioe.printStackTrace();
        }
    }

    private class NamedEntityDataProvider
    extends AbstractDataSupplier<Double, Attribute.EntityCollection>
    implements NamedDataSupplier<Double> {
        String name;

        public NamedEntityDataProvider(Attribute.EntityCollection entities, String name) {
            super((Object)entities);
            this.name = "";
            this.name = name;
        }

        public int size() {
            return ((Attribute.EntityCollection)this.input).getEntities().size();
        }

        public Double get(int i) {
            return ((Attribute.EntityCollection)this.input).getEntity((long)i).getDouble(this.getName());
        }

        public String getName() {
            return this.name;
        }
    }
}

