/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.DefaultDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@JAMSComponentDescription(title="MODIS_ET_Reader", author="Sven Kralisch", description="Read TAB-separated MODIS ET data generated by MODIS processor", date="2016-04-13", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2016-04-13", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2016-07-01", comment="Fixed file read error at end of file")})
public class MODIS_ET_Reader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="MODIS input file name")
    public Attribute.String modisFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current model time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output values to info log?", defaultValue="false")
    public Attribute.Boolean debug;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="MODIS ET values of current time step")
    public Attribute.DoubleArray modisETArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of HRU IDs from MODIS file")
    public Attribute.IntegerArray hruIDArray;
    transient BufferedReader reader;
    int startMonth = 0;
    int cMonth = 0;
    int oldMonth = 0;
    String line = "";
    List<Integer> idList = new ArrayList<Integer>();
    List<Double> valueList = new ArrayList<Double>();
    int[] idArray;
    double[] valueArray;

    public void init() {
        File f = new File(this.modisFileName.getValue());
        File file = f.isAbsolute() ? new File(this.modisFileName.getValue()) : new File(this.getModel().getWorkspacePath(), this.modisFileName.getValue());
        try {
            this.reader = new BufferedReader(new FileReader(file));
            this.reader.readLine();
            this.line = this.reader.readLine();
            String[] parts = this.line.split("\t");
            this.cMonth = this.startMonth = Integer.parseInt(parts[0]) * 12 + Integer.parseInt(parts[1]);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
    }

    public void run() {
        int month = this.time.get(1) * 12 + this.time.get(2) + 1;
        if (this.oldMonth == month) {
            return;
        }
        if (this.startMonth > month) {
            this.modisETArray.setValue(new double[0]);
            return;
        }
        while (true) {
            String[] parts = this.line.split("\t");
            this.cMonth = Integer.parseInt(parts[0]) * 12 + Integer.parseInt(parts[1]);
            if (this.cMonth >= month) break;
            try {
                this.line = this.reader.readLine();
            }
            catch (IOException ex) {
                this.getModel().getRuntime().handle((Throwable)ex);
            }
        }
        if (this.cMonth == month) {
            this.oldMonth = month;
        }
        int i = 0;
        while (this.line != null) {
            String[] parts = this.line.split("\t");
            this.cMonth = Integer.parseInt(parts[0]) * 12 + Integer.parseInt(parts[1]);
            if (this.cMonth != month) break;
            try {
                int n = Integer.parseInt(parts[2]);
                double value = Double.parseDouble(parts[3]);
                if (this.idArray == null) {
                    this.idList.add(n);
                    this.valueList.add(value);
                } else {
                    this.idArray[i] = n;
                    this.valueArray[i] = value;
                    ++i;
                }
                this.line = this.reader.readLine();
            }
            catch (IOException iOException) {
                this.getModel().getRuntime().handle((Throwable)iOException);
            }
        }
        if (this.idArray == null) {
            int j;
            this.idArray = new int[this.idList.size()];
            for (j = 0; j < this.idList.size(); ++j) {
                this.idArray[j] = this.idList.get(j);
            }
            this.valueArray = new double[this.valueList.size()];
            for (j = 0; j < this.valueList.size(); ++j) {
                this.valueArray[j] = this.valueList.get(j);
            }
            this.modisETArray.setValue(this.valueArray);
            this.hruIDArray.setValue(this.idArray);
        }
        if (this.debug.getValue()) {
            String s = "";
            for (int id : this.hruIDArray.getValue()) {
                s = s + id + " - ";
            }
            this.getModel().getRuntime().println(s);
            s = "";
            for (double v : this.modisETArray.getValue()) {
                s = s + v + " - ";
            }
            this.getModel().getRuntime().println(s);
        }
    }

    public void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            this.getModel().getRuntime().handle((Throwable)ex);
        }
    }

    public static void main(String[] args) {
        MODIS_ET_Reader r = new MODIS_ET_Reader();
        DataFactory f = DefaultDataFactory.getDataFactory();
        r.modisFileName = f.createString();
        r.modisFileName.setValue("D:\\jamsmodeldata\\JAMS-BJ_2\\input\\local\\modis-results\\modis.csv");
        r.time = f.createCalendar();
        r.modisETArray = f.createDoubleArray();
        r.hruIDArray = f.createIntegerArray();
        r.init();
        r.time.setValue("2002/1/1 12:00");
        r.run();
        for (int id : r.hruIDArray.getValue()) {
            System.out.print(id + " - ");
        }
        System.out.println("");
        for (double v : r.modisETArray.getValue()) {
            System.out.print(v + " - ");
        }
        System.out.println("");
        r.time.setValue("2002/2/1 12:00");
        r.run();
        for (int id : r.hruIDArray.getValue()) {
            System.out.print(id + " - ");
        }
        System.out.println("");
        for (double v : r.modisETArray.getValue()) {
            System.out.print(v + " - ");
        }
        r.cleanup();
    }
}

