/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.data.JAMSData;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

@JAMSComponentDescription(title="JAMSData Writer", author="Sven Kralisch", description="Write values of arbitrary JAMSData objects to file.")
public class JAMSDataWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of output file")
    public Attribute.String outputFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Header of output file (i.e. attribute names)")
    public Attribute.StringArray header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attributes to be written")
    public JAMSData[] attributes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Comment")
    public Attribute.String comment;

    public void cleanup() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.getModel().getWorkspaceDirectory().getPath() + File.separator + this.outputFile.getValue()));
            writer.write("#JAMSDataWriter output file");
            writer.newLine();
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            writer.write("#Date: " + sdf.format(cal.getTime()));
            writer.newLine();
            if (this.comment != null) {
                writer.write("#Comment: " + this.comment.getValue());
                writer.newLine();
            }
            for (String string : this.header.getValue()) {
                writer.write(string + "\t");
            }
            writer.newLine();
            for (String string : this.attributes) {
                writer.write(string.toString() + "\t");
            }
            writer.close();
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
    }
}

