/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import com.vividsolutions.jts.geom.Geometry;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;

@JAMSComponentDescription(title="GeomReader", author="Christian Schwartze", description="Reads geometries from HRU shapefile and adds them to JAMS entities as spatial attributes.", date="2010-10-22")
public class GeomReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="shape file name")
    public Attribute.String shapeFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of identifier column in shape file")
    public Attribute.String idName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Original Shape file name")
    public Attribute.String baseShape;

    public void init() {
        try {
            URL shapeUrl = new File(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.shapeFileName.getValue()).toURI().toURL();
            ShapefileDataStore shapefile = new ShapefileDataStore(shapeUrl);
            List featureNames = shapefile.getNames();
            FeatureSource featureSource = null;
            try {
                featureSource = shapefile.getFeatureSource((Name)featureNames.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.baseShape.setValue(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.shapeFileName.getValue() + ";" + this.idName);
            FeatureIterator iterator = featureSource.getFeatures().features();
            HashMap<Long, Geometry> geomMap = new HashMap<Long, Geometry>();
            while (iterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)iterator.next();
                Object attribute = f.getAttribute(this.idName.getValue());
                if (attribute == null) {
                    iterator.close();
                    this.getModel().getRuntime().sendInfoMsg("Could not access attribute " + this.idName.getValue() + ". Please check your shapefile!");
                    return;
                }
                Long id = null;
                try {
                    id = Long.parseLong(attribute.toString());
                }
                catch (NumberFormatException nfe) {
                    id = (long)Double.parseDouble(attribute.toString());
                }
                geomMap.put(id, (Geometry)f.getDefaultGeometry());
            }
            iterator.close();
            for (Attribute.Entity e : this.hrus.getEntities()) {
                long id = new Double(e.getDouble("ID")).longValue();
                e.setGeometry("geom", (Geometry)geomMap.get(id));
            }
        }
        catch (IOException ex) {
            this.getModel().getRuntime().sendErrorMsg("An error occured while trying to load geometries from " + new File(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.shapeFileName.getValue()).getAbsolutePath() + " (" + ex.getMessage() + ")");
        }
    }
}

