/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.workspace.DataSetDefinition;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.TSDataStore;
import java.util.ArrayList;

@JAMSComponentDescription(title="GenericTSReader", author="Sven Kralisch", date="2012-09-26", version="1.0_0", description="This component can be used obtain data from a time series data store which contains only double values. Metadata are provided as a sorted list of double values for each column.")
public class GenericTSReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Datastore ID")
    public Attribute.String id;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of column indices to be accessed [0..length-1]")
    public Attribute.IntegerArray columnIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The time interval within which the component shall read data from the datastore")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Datastore metadata attribute names")
    public Attribute.StringArray metadataAttributes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Datastore metadata values - one DoubleArray for each column indicated by columnIDs")
    public Attribute.StringArray[] metadataValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Datastore data - one Double for each column indicated by columnIDs")
    public Attribute.Double[] dataValues;
    private TSDataStore store;
    boolean shifted = false;

    public void init() {
        this.shifted = false;
        InputDataStore is = null;
        if (this.id != null) {
            is = this.getModel().getWorkspace().getInputDataStore(this.id.getValue());
        }
        if (is == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Datastore could not be found!");
            return;
        }
        if (!(is instanceof TSDataStore)) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Datastore is not a time series datastore!");
            return;
        }
        this.store = (TSDataStore)is;
        if (this.store.getStartDate().after(this.timeInterval.getStart()) && this.store.getStartDate().compareTo(this.timeInterval.getStart(), this.timeInterval.getTimeUnit()) != 0) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Start date of datastore (" + this.store.getStartDate() + ") does not match given time interval (" + this.timeInterval.getStart() + ")!");
            return;
        }
        if (this.store.getEndDate().before(this.timeInterval.getEnd()) && this.store.getEndDate().compareTo(this.timeInterval.getEnd(), this.timeInterval.getTimeUnit()) != 0) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": End date of datastore (" + this.store.getEndDate() + ") does not match given time interval (" + this.timeInterval.getEnd() + ")!");
            return;
        }
        DataSetDefinition dsDef = this.store.getDataSetDefinition();
        String[] metadataAttributesArray = dsDef.getAttributeNames().toArray(new String[dsDef.getAttributeNames().size()]);
        this.metadataAttributes.setValue(metadataAttributesArray);
        if (this.metadataValues.length != this.columnIDs.getValue().length) {
            this.getModel().getRuntime().sendErrorMsg("Mismatch of indicated columns and number of metadata attributes (metadataValues)! Reading of metadata will be skipped.");
        } else {
            int i = 0;
            for (int colID : this.columnIDs.getValue()) {
                String[] metadataValuesArray = new String[metadataAttributesArray.length];
                ArrayList l = dsDef.getAttributeValues(colID);
                int j = 0;
                for (Object o : l) {
                    metadataValuesArray[j++] = o.toString();
                }
                this.metadataValues[i++].setValue(metadataValuesArray);
            }
        }
        if (this.dataValues.length != this.columnIDs.getValue().length) {
            this.getModel().getRuntime().sendHalt("Mismatch of indicated columns and number of data attributes! Will stop model execution.");
        }
        this.getModel().getRuntime().println("Datastore " + this.id + " initialized!", 3);
    }

    private void checkConsistency() {
        if (!this.shifted && this.store.getStartDate().before(this.timeInterval.getStart()) && this.store.getStartDate().compareTo(this.timeInterval.getStart(), this.timeInterval.getTimeUnit()) != 0) {
            this.shifted = true;
            Attribute.Calendar current = this.store.getStartDate().clone();
            Attribute.Calendar targetDate = this.timeInterval.getStart().clone();
            current.removeUnsignificantComponents(this.timeInterval.getTimeUnit());
            targetDate.removeUnsignificantComponents(this.timeInterval.getTimeUnit());
            int timeUnit = this.timeInterval.getTimeUnit();
            int timeUnitCount = this.timeInterval.getTimeUnitCount();
            if (timeUnit >= 3) {
                long diff = (targetDate.getTimeInMillis() - current.getTimeInMillis()) / 1000L;
                switch (timeUnit) {
                    case 6: {
                        int steps = (int)diff / 3600 / 24;
                        break;
                    }
                    case 11: {
                        int steps = (int)diff / 3600;
                        break;
                    }
                    case 3: {
                        int steps = (int)diff / 3600 / 24 / 7;
                        break;
                    }
                    case 12: {
                        int steps = (int)diff / 60;
                        break;
                    }
                    default: {
                        int steps = (int)diff;
                    }
                }
                this.store.skip(steps /= timeUnitCount);
            } else {
                targetDate.add(timeUnit, -1 * timeUnitCount);
                while (current.compareTo(targetDate, timeUnit) < 0) {
                    this.store.getNext();
                    current.add(timeUnit, timeUnitCount);
                }
            }
        }
    }

    public void run() {
        this.checkConsistency();
        DefaultDataSet ds = this.store.getNext();
        DataValue[] data = ds.getData();
        int i = 0;
        for (int colID : this.columnIDs.getValue()) {
            this.dataValues[i++].setValue(data[colID + 1].getDouble());
        }
    }

    public void cleanup() {
        this.store.close();
    }
}

