/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;

@JAMSComponentDescription(title="Entity file writer (spatial)", author="Sven Kralisch", description="This component can be used to output a number of selected entity attribute values at a certain point in time. The resulting CSV formatted ASCII file will contain one line per entity and one column per attribute. This component must be wrapped in a spatial, but not in a temporal context!")
public class EntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.StringArray headers;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attributes")
    public Attribute.Double[] value;
    private GenericDataWriter writer;

    public void init() {
        this.writer = new GenericDataWriter(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.fileName.getValue());
        this.writer.addComment("Entity attribute values");
        this.writer.addComment("");
        for (int i = 0; i < this.headers.getValue().length; ++i) {
            this.writer.addColumn(this.headers.getValue()[i]);
        }
        this.writer.writeHeader();
    }

    public void run() {
        for (int i = 0; i < this.value.length; ++i) {
            this.writer.addData((Object)this.value[i]);
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().println(jre.getMessage());
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

