/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.JAMS;
import jams.components.aggregate.TSAggregator;
import jams.components.indices.GammaDistributionEstimatedProbabilities;
import jams.data.Attribute;
import jams.data.JAMSDataFactory;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class StandardPrecipitationIndex {
    public static double MISSING_DATA_VALUE = -9999.0;

    public static double[] parse(double[] precipitation) {
        double[] spi = new double[]{};
        if (precipitation != null && precipitation.length > 0) {
            GammaDistributionEstimatedProbabilities.Parameters p = new GammaDistributionEstimatedProbabilities.Parameters();
            GammaDistributionEstimatedProbabilities.gamma_fit(precipitation, p);
            spi = new double[precipitation.length];
            for (int i = 0; i < precipitation.length; ++i) {
                double precipValue = precipitation[i];
                if (precipValue != JAMS.getMissingDataValue()) {
                    spi[i] = GammaDistributionEstimatedProbabilities.gamma_cdf(p.beta, p.gamma, p.pzero, precipValue);
                    spi[i] = GammaDistributionEstimatedProbabilities.inv_normal(spi[i]);
                    continue;
                }
                spi[i] = JAMS.getMissingDataValue();
            }
        }
        return spi;
    }

    private static double[][] toMonthlyGrouped(double[] a) {
        int i;
        int maxLength = (int)Math.ceil((float)a.length / 12.0f);
        int minLength = a.length / 12;
        int mod = a.length % 12;
        double[][] b = new double[12][];
        for (i = 0; i < mod; ++i) {
            b[i] = new double[maxLength];
        }
        for (i = mod; i < b.length; ++i) {
            b[i] = new double[minLength];
        }
        for (i = 0; i < a.length; ++i) {
            int m = i % 12;
            int n = i / 12;
            b[m][n] = a[i];
        }
        return b;
    }

    public static double[] calcSPI(double[] monthlyValues) {
        int i;
        double[] a = monthlyValues;
        double[][] groups = StandardPrecipitationIndex.toMonthlyGrouped(a);
        for (int i2 = 0; i2 < groups.length; ++i2) {
            groups[i2] = StandardPrecipitationIndex.parse(groups[i2]);
        }
        a = new double[a.length];
        int c = 0;
        int minLength = groups[0].length - 1;
        for (i = 0; i < minLength; ++i) {
            for (int j = 0; j < groups.length; ++j) {
                a[c++] = groups[j][i];
            }
        }
        for (i = 0; i < groups.length; ++i) {
            if (groups[i].length <= minLength) continue;
            a[c++] = groups[i][minLength];
        }
        return a;
    }

    private static double[] getEmptyArray(int n) {
        double[] a = new double[n];
        for (int i = 0; i < a.length; ++i) {
            a[i] = MISSING_DATA_VALUE;
        }
        return a;
    }

    public static double[] calcSPIn(double[] monthlyValues, int n) {
        int i;
        double[] a = monthlyValues;
        if (a.length - n + 1 < 1) {
            return StandardPrecipitationIndex.getEmptyArray(monthlyValues.length);
        }
        double[] m = new double[a.length - n + 1];
        for (i = n - 1; i < a.length; ++i) {
            double sum = 0.0;
            for (int j = i - n + 1; j <= i; ++j) {
                sum += a[j];
            }
            m[i - n + 1] = sum /= (double)n;
        }
        m = StandardPrecipitationIndex.calcSPI(m);
        for (i = 0; i < n - 1; ++i) {
            a[i] = MISSING_DATA_VALUE;
        }
        for (i = n - 1; i < a.length; ++i) {
            a[i] = m[i - n + 1];
        }
        return a;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String s;
        BufferedReader r = new BufferedReader(new FileReader("D:\\temp\\SPI\\commadelimited_daily_wdates.csv"));
        r.readLine();
        ArrayList<Attribute.Calendar> dates = new ArrayList<Attribute.Calendar>();
        Attribute.Calendar c = JAMSDataFactory.createCalendar();
        c.set(1913, 0, 1, 0, 0, 0);
        ArrayList<Double> list = new ArrayList<Double>();
        while ((s = r.readLine()) != null) {
            s = s.split(",")[1];
            list.add(Double.parseDouble(s));
            dates.add(c.clone());
            c.add(6, 1);
        }
        double[] data = new double[list.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Double)list.get(i);
        }
        TSAggregator agg = new TSAggregator(data, dates, 0);
        double[] a = agg.toMonthly().values;
        for (double d : a = StandardPrecipitationIndex.calcSPIn(a, 12)) {
            System.out.println(d);
        }
    }
}

