/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.util.ArrayList;

@JAMSComponentDescription(title="KlimaKennwerte", author="Christian Fischer", description="Calculated standard Klimakennwerte for J2000Klima")
public class PfannschmidtIndices
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily min temperatur", unit="\u00b0C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily mean temperatur", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily max temperatur", unit="\u00b0C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the summer index after pfannschmidt (mean of tmax between first and last summer day)")
    public Attribute.Double summerIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the summer index after pfannschmidt (mean of tmax between first and last summer day)")
    public Attribute.Double summerStartDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the summer index after pfannschmidt (mean of tmax between first and last summer day)")
    public Attribute.Double winterIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates the summer index after pfannschmidt (mean of tmax between first and last summer day)")
    public Attribute.Double winterStartDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="switch for histogramm calculation. If 1 than the histogramm is applied otherwise the mean is used", defaultValue="false")
    public Attribute.Boolean histogrammCalculation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="tmp variables")
    public Attribute.Object internalState;
    private final int INDEX_SUMMERINDEX = 0;
    private final int INDEX_WINTERINDEX = 1;
    private final int INDEX_SIZE = 2;

    public void run() {
        double dayOfYear = this.time.get(6);
        boolean isSummerDay = false;
        boolean isWinterDay = false;
        if (this.tmax.getValue() >= 25.0) {
            if (this.summerStartDay.getValue() == 0.0) {
                this.summerStartDay.setValue(dayOfYear);
            }
            isSummerDay = true;
        }
        if (this.tmin.getValue() < 0.0) {
            if (this.winterStartDay.getValue() == 0.0) {
                this.winterStartDay.setValue(dayOfYear);
            }
            isWinterDay = true;
        }
        if (this.histogrammCalculation.getValue()) {
            this.PfannschmidtHistogramm((int)dayOfYear, isSummerDay, isWinterDay);
        } else {
            this.PfannschmidtMean((int)dayOfYear, isSummerDay, isWinterDay);
        }
    }

    private void PfannschmidtMean(int dayOfYear, boolean isSummerDay, boolean isWinterDay) {
        double days;
        if (this.internalState.getValue() == null) {
            this.internalState.setValue((Object)new double[2]);
        }
        double[] inTmp = (double[])this.internalState.getValue();
        if (this.summerStartDay.getValue() > 0.0) {
            inTmp[0] = inTmp[0] + this.tmax.getValue();
            if (isSummerDay) {
                days = (double)dayOfYear - this.summerStartDay.getValue() + 1.0;
                this.summerIndex.setValue(inTmp[0] / days);
            }
        }
        if (this.winterStartDay.getValue() > 0.0) {
            inTmp[1] = inTmp[1] + this.tmin.getValue();
            if (isWinterDay) {
                days = (double)dayOfYear - this.winterStartDay.getValue() + 1.0;
                if (days < 0.0) {
                    days += 365.0;
                }
                this.winterIndex.setValue(inTmp[1] / days);
            }
        }
        if (dayOfYear == 1) {
            this.summerStartDay.setValue(0.0);
            inTmp[0] = 0.0;
        }
        if (dayOfYear == 180) {
            this.winterStartDay.setValue(0.0);
            inTmp[1] = 0.0;
        }
    }

    private void PfannschmidtHistogramm(int dayOfYear, boolean isSummerDay, boolean isWinterDay) {
        int i;
        double classMid;
        int i2;
        double total;
        double wSum;
        int tempClass;
        if (this.internalState.getValue() == null) {
            ArrayList[] tmp = new ArrayList[]{new ArrayList(), new ArrayList()};
            this.internalState.setValue((Object)tmp);
        }
        ArrayList[] inTmp = (ArrayList[])this.internalState.getValue();
        ArrayList summerHistogramm = inTmp[0];
        ArrayList winterHistogramm = inTmp[1];
        if (this.summerStartDay.getValue() > 0.0) {
            tempClass = (int)this.tmax.getValue();
            tempClass = tempClass < 0 ? -2 * tempClass : tempClass * 2 + 1;
            while (summerHistogramm.size() <= tempClass) {
                summerHistogramm.add(0.0);
            }
            summerHistogramm.set(tempClass, (Double)summerHistogramm.get(tempClass) + 1.0);
            if (isSummerDay) {
                wSum = 0.0;
                total = 0.0;
                for (i2 = 0; i2 < summerHistogramm.size(); ++i2) {
                    classMid = 0.0;
                    classMid = i2 % 2 == 0 ? (double)(-i2 / 2) + 0.5 : (double)((i2 - 1) / 2) + 0.5;
                    wSum += classMid * (Double)summerHistogramm.get(i2);
                    total += ((Double)summerHistogramm.get(i2)).doubleValue();
                }
                this.summerIndex.setValue(wSum / total);
            }
        }
        if (this.winterStartDay.getValue() > 0.0) {
            tempClass = (int)this.tmin.getValue();
            tempClass = tempClass < 0 ? -2 * tempClass : tempClass * 2 + 1;
            while (winterHistogramm.size() <= tempClass) {
                winterHistogramm.add(0.0);
            }
            winterHistogramm.set(tempClass, (Double)winterHistogramm.get(tempClass) + 1.0);
            if (isWinterDay) {
                wSum = 0.0;
                total = 0.0;
                for (i2 = 0; i2 < winterHistogramm.size(); ++i2) {
                    classMid = 0.0;
                    classMid = i2 % 2 == 0 ? (double)(-i2 / 2) + 0.5 : (double)((i2 - 1) / 2) + 0.5;
                    wSum += classMid * (Double)winterHistogramm.get(i2);
                    total += ((Double)winterHistogramm.get(i2)).doubleValue();
                }
                this.winterIndex.setValue(wSum / total);
            }
        }
        if (dayOfYear == 1) {
            this.summerStartDay.setValue(0.0);
            for (i = 0; i < summerHistogramm.size(); ++i) {
                inTmp[0].set(i, 0.0);
            }
        }
        if (dayOfYear == 180) {
            this.winterStartDay.setValue(0.0);
            for (i = 0; i < winterHistogramm.size(); ++i) {
                inTmp[1].set(i, 0.0);
            }
        }
    }
}

