/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.JAMS;

public class GammaDistributionEstimatedProbabilities {
    private static final int MAX_ITERATIONS = 100;
    private static final double DBL_EPSILON = 3.0E-7;

    static double inv_normal(double prob) {
        double minus;
        double c0 = 2.515517;
        double c1 = 0.802853;
        double c2 = 0.010328;
        double d1 = 1.432788;
        double d2 = 0.189269;
        double d3 = 0.001308;
        if (prob > 0.5) {
            minus = 1.0;
            prob = 1.0 - prob;
        } else {
            minus = -1.0;
        }
        if (prob < 0.0) {
            throw new ArithmeticException("Probability not in [0,1.0].");
        }
        if (prob == 0.0) {
            return 9999.0 * minus;
        }
        double t = Math.sqrt(Math.log(1.0 / (prob * prob)));
        return minus * (t - ((c2 * t + c1) * t + c0) / (((d3 * t + d2) * t + d1) * t + 1.0));
    }

    static int gamma_fit(double[] datarr, Parameters params) {
        if (datarr == null || datarr.length <= 0) {
            return 0;
        }
        double sum = 0.0;
        double sumlog = 0.0;
        double mn = 0.0;
        double nact = 0.0;
        double pzero = 0.0;
        for (int i = 0; i < datarr.length; ++i) {
            if (datarr[i] == JAMS.getMissingDataValue()) continue;
            if (datarr[i] > 0.0) {
                sum += datarr[i];
                sumlog += Math.log(datarr[i]);
                nact += 1.0;
                continue;
            }
            pzero += 1.0;
        }
        pzero /= nact + pzero;
        if (nact != 0.0) {
            mn = sum / nact;
        }
        if (nact == 1.0) {
            double alpha = 0.0;
            double gamma = 1.0;
            double beta = mn;
            return (int)nact;
        }
        if (pzero == 1.0) {
            double alpha = 0.0;
            double gamma = 1.0;
            double beta = mn;
            return (int)nact;
        }
        double alpha = Math.log(mn) - sumlog / nact;
        double gamma = (1.0 + Math.sqrt(1.0 + 4.0 * alpha / 3.0)) / (4.0 * alpha);
        double beta = mn / gamma;
        params.alpha = alpha;
        params.beta = beta;
        params.gamma = gamma;
        params.pzero = pzero;
        return (int)nact;
    }

    static double gamma_cdf(double beta, double gamm, double pzero, double x) {
        if (x <= 0.0) {
            return pzero;
        }
        return pzero + (1.0 - pzero) * GammaDistributionEstimatedProbabilities.gammap(gamm, x / beta);
    }

    private static double gammser(double a, double x) {
        double sum;
        double gln = GammaDistributionEstimatedProbabilities.lgamma(a);
        if (x == 0.0) {
            return 0.0;
        }
        double ap = a;
        double del = sum = 1.0 / a;
        for (int n = 0; n < 100; ++n) {
            if (Math.abs(del) < 3.0E-7 * Math.abs(sum += (del *= x / (ap += 1.0)))) break;
        }
        return sum * Math.exp(-x + a * Math.log(x) - gln);
    }

    private static double gammcf(double a, double x) {
        double gln = GammaDistributionEstimatedProbabilities.lgamma(a);
        double g = 0.0;
        double gold = 0.0;
        double a0 = 1.0;
        double a1 = x;
        double b0 = 0.0;
        double b1 = 1.0;
        double fac = 1.0;
        for (int n = 1; n <= 100; ++n) {
            double an = n;
            double ana = an - a;
            a0 = (a1 + a0 * ana) * fac;
            b0 = (b1 + b0 * ana) * fac;
            double anf = an * fac;
            a1 = x * a0 + anf * a1;
            b1 = x * b0 + anf * b1;
            if (a1 == 0.0) continue;
            fac = 1.0 / a1;
            g = b1 * fac;
            if (Math.abs((g - gold) / g) < 3.0E-7) break;
            gold = g;
        }
        return g * Math.exp(-x + a * Math.log(x) - gln);
    }

    private static double gammap(double a, double x) {
        if (x < a + 1.0) {
            return GammaDistributionEstimatedProbabilities.gammser(a, x);
        }
        return 1.0 - GammaDistributionEstimatedProbabilities.gammcf(a, x);
    }

    private static double lgamma(double gmm) {
        double y;
        double[] cof = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};
        double x = y = gmm;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.00000000019005;
        for (int j = 0; j < cof.length; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return -tmp + Math.log(2.50662827465 * ser / x);
    }

    public static class Parameters {
        double alpha;
        double beta;
        double gamma;
        double pzero;
    }
}

