/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JAMSComponentDescription(title="Soil Moisture Deficit Index (SMDI) Calculator", author="Sven Kralisch", description="This component calculates the Soil Moisture Deficit Index (SMDI)", date="2017-04-17", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public abstract class AbstractDICalc
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current date")
    public Attribute.Calendar date;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Size of aggregation window for baseline statistics (e.g. \"7\" for weekly stats)", defaultValue="7")
    public Attribute.Integer tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Counter of overall values stored")
    public Attribute.Integer counter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output of long-term statistics for each(!) entity", defaultValue="false")
    public Attribute.Boolean debug;
    protected int statRes = 0;
    protected int tres = 1;

    public void init() {
        this.tres = this.tempRes.getValue();
        this.statRes = 365 / this.tres;
    }

    public void initAll() {
        this.counter.setValue(0);
    }

    public abstract void run();

    protected Stats calcStats(double[] valueList) {
        int i;
        List[] groupedValues = new List[this.statRes];
        for (int i2 = 0; i2 < groupedValues.length; ++i2) {
            groupedValues[i2] = new ArrayList();
        }
        int index = 0;
        for (double value : valueList) {
            groupedValues[index].add(value);
            if (++index != this.statRes) continue;
            index = 0;
        }
        Stats stats = new Stats(groupedValues.length);
        for (i = 0; i < groupedValues.length; ++i) {
            List list = groupedValues[i];
            ArrayList sortedList = new ArrayList(list);
            if (list.isEmpty()) continue;
            Collections.sort(sortedList);
            stats.median[i] = sortedList.size() % 2 == 0 ? ((Double)sortedList.get(sortedList.size() / 2) + (Double)sortedList.get(sortedList.size() / 2 - 1)) / 2.0 : (Double)sortedList.get(sortedList.size() / 2);
            stats.min[i] = (Double)sortedList.get(0);
            stats.max[i] = (Double)sortedList.get(sortedList.size() - 1);
        }
        if (this.debug.getValue()) {
            this.getModel().getRuntime().println("Long-term stats:");
            for (i = 0; i < groupedValues.length; ++i) {
                this.getModel().getRuntime().println(i + ":\t" + stats.min[i] + "\t" + stats.median[i] + "\t" + stats.max[i]);
            }
        }
        return stats;
    }

    public class Stats {
        double[] min;
        double[] max;
        double[] median;

        public Stats(int size) {
            this.min = new double[size];
            this.max = new double[size];
            this.median = new double[size];
        }
    }
}

