/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.JTSConfigurator;
import jams.components.gui.spreadsheet.JXYConfigurator;
import jams.data.Attribute;
import jams.gui.tools.GUIHelper;
import jams.tools.JAMSTools;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.geom.Ellipse2D;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.ShapeUtilities;

public class GraphProperties {
    JFrame parent;
    URL url1 = this.getClass().getResource("/jams/components/gui/resources/arrowup.png");
    ImageIcon up_icon = new ImageIcon(this.url1);
    URL url2 = this.getClass().getResource("/jams/components/gui/resources/arrowdown.png");
    ImageIcon down_icon = new ImageIcon(this.url2);
    URL url3 = this.getClass().getResource("/jams/components/gui/resources/correct.png");
    ImageIcon plot_icon = new ImageIcon(this.url3);
    URL url4 = this.getClass().getResource("/jams/components/gui/resources/add.png");
    ImageIcon add_icon = new ImageIcon(this.url4);
    URL url5 = this.getClass().getResource("/jams/components/gui/resources/remove.png");
    ImageIcon rem_icon = new ImageIcon(this.url5);
    GraphProperties thisProp;
    JTable table;
    TimeSeries ts;
    XYSeries xys;
    JScrollPane scpane;
    int index = 0;
    String legendName;
    int color;
    String name;
    String position;
    int type;
    int[] d_range = new int[2];
    boolean is_x_series = false;
    boolean result = false;
    boolean x_changed;
    int selectedColumn;
    int[] rowSelection;
    int x_series_col;
    int stroke_type;
    int shape_type;
    int size_type;
    int outline_type;
    double data_range_start;
    double data_range_end;
    int plotType;
    JComboBox setColumn;
    JComboBox colorchoice;
    JComboBox typechoice;
    JComboBox poschoice;
    JComboBox timechoice_START;
    JComboBox timechoice_END;
    JTextField datachoice_START;
    JTextField datachoice_END;
    JPanel datachoice_panel;
    JButton datachoice_max;
    JButton addButton;
    JButton remButton;
    JButton plotButton;
    JButton upButton;
    JButton downButton;
    JButton customizeButton;
    JCheckBox invBox;
    JToggleButton isXAxis;
    JLabel nameLabel;
    JTextField setName;
    JTextField setLegend;
    JTSConfigurator ctsconf;
    JXYConfigurator cxyconf;
    double[] x_dataIntervals;
    double[] y_data;
    private String[] colors = new String[]{"red", "blue", "green", "black", "magenta", "cyan", "yellow", "gray", "orange", "lightgray", "pink"};
    private String[] types = new String[]{"Line", "Bar", "Area", "Line and Base", "Dot", "Step", "StepArea", "Difference"};
    private String[] positions = new String[]{"left", "right"};
    JPanel graphpanel = new JPanel();
    JPanel datapanel = new JPanel();
    JPanel buttonpanel = new JPanel();
    Stroke series_stroke;
    Shape series_shape;
    Color series_paint;
    Stroke series_outline_stroke;
    Color series_outline_paint;
    Color series_fill_paint;
    ColorLabel colorlabel;
    boolean outlineVisible;
    boolean linesVisible;
    boolean shapesVisible;
    HashMap<String, Color> colorTable = new HashMap();
    CustomizeRendererDlg cr_dlg;
    ActionListener timeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            GraphProperties.this.setPossibleTimeIntervals();
        }
    };
    ActionListener rendererListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (GraphProperties.this.plotType == 0) {
                GraphProperties.this.ctsconf.handleRenderer();
            }
            if (GraphProperties.this.plotType == 1) {
                GraphProperties.this.cxyconf.handleRenderer();
            }
        }
    };
    ActionListener addListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (GraphProperties.this.plotType == 0) {
                GraphProperties.this.ctsconf.addGraph(GraphProperties.this.thisProp);
            }
            if (GraphProperties.this.plotType == 1) {
                GraphProperties.this.cxyconf.addGraph(GraphProperties.this.thisProp);
            }
        }
    };
    ActionListener removeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (GraphProperties.this.plotType == 0) {
                GraphProperties.this.ctsconf.removeGraph(GraphProperties.this.thisProp);
            }
            if (GraphProperties.this.plotType == 1) {
                GraphProperties.this.cxyconf.removeGraph(GraphProperties.this.thisProp);
            }
        }
    };
    ActionListener upListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (GraphProperties.this.plotType == 0) {
                GraphProperties.this.ctsconf.upGraph(GraphProperties.this.thisProp);
            }
            if (GraphProperties.this.plotType == 1) {
                GraphProperties.this.cxyconf.upGraph(GraphProperties.this.thisProp);
            }
        }
    };
    ActionListener downListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            if (GraphProperties.this.plotType == 0) {
                GraphProperties.this.ctsconf.downGraph(GraphProperties.this.thisProp);
            }
            if (GraphProperties.this.plotType == 1) {
                GraphProperties.this.cxyconf.downGraph(GraphProperties.this.thisProp);
            }
        }
    };
    ActionListener isXListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent xe) {
            GraphProperties.this.cxyconf.xChanged(GraphProperties.this.thisProp);
            GraphProperties.this.cxyconf.setMaxDataIntervals(GraphProperties.this.thisProp);
        }
    };
    ActionListener max_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent me) {
            GraphProperties.this.cxyconf.setMaxDataIntervals(GraphProperties.this.thisProp);
        }
    };
    ActionListener customize_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent me) {
            if (GraphProperties.this.getPosition() == "left") {
                if (GraphProperties.this.plotType == 0) {
                    GraphProperties.this.setRendererType(GraphProperties.this.ctsconf.getRendererLeft());
                }
                if (GraphProperties.this.plotType == 1) {
                    GraphProperties.this.setRendererType(GraphProperties.this.cxyconf.getRendererLeft());
                }
            }
            if (GraphProperties.this.getPosition() == "right") {
                if (GraphProperties.this.plotType == 0) {
                    GraphProperties.this.setRendererType(GraphProperties.this.ctsconf.getRendererRight());
                }
                if (GraphProperties.this.plotType == 1) {
                    GraphProperties.this.setRendererType(GraphProperties.this.cxyconf.getRendererRight());
                }
            }
            GraphProperties.this.cr_dlg.handleGUI();
            GraphProperties.this.cr_dlg.setVisible(true);
        }
    };
    MouseAdapter dataSTARTListener = new MouseAdapter(){

        public void mouseClicked() {
            GraphProperties.this.datachoice_START.selectAll();
        }
    };
    MouseAdapter dataENDListener = new MouseAdapter(){

        public void mouseClicked() {
            GraphProperties.this.datachoice_END.selectAll();
        }
    };
    DocumentListener d_start_listener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            GraphProperties.this.cxyconf.dStartChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GraphProperties.this.cxyconf.dStartChanged(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GraphProperties.this.cxyconf.dStartChanged(true);
        }
    };
    DocumentListener d_end_listener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            GraphProperties.this.cxyconf.dEndChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GraphProperties.this.cxyconf.dEndChanged(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GraphProperties.this.cxyconf.dEndChanged(true);
        }
    };

    public GraphProperties(JTSConfigurator ctsconf) {
        this.parent = ctsconf;
        this.plotType = 0;
        this.ctsconf = ctsconf;
        this.thisProp = this;
        this.table = ctsconf.table;
        this.position = "left";
        this.legendName = this.name = "Graph Name";
        this.selectedColumn = 0;
        this.rowSelection = null;
        String[] timeIntervals = new String[this.table.getRowCount()];
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            timeIntervals[i] = this.table.getValueAt(i, 0).toString();
        }
        this.timechoice_START = new JComboBox<String>(timeIntervals);
        this.timechoice_START.setPreferredSize(new Dimension(40, 14));
        this.timechoice_START.addActionListener(this.timeListener);
        this.timechoice_END = new JComboBox<String>(timeIntervals);
        this.timechoice_END.setPreferredSize(new Dimension(40, 14));
        this.timechoice_END.addActionListener(this.timeListener);
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.colorTable.put("white", Color.WHITE);
        this.createPanel();
        this.applyTSProperties();
    }

    public GraphProperties(JXYConfigurator cxyconf) {
        this.parent = cxyconf;
        this.plotType = 1;
        this.cxyconf = cxyconf;
        this.thisProp = this;
        this.table = cxyconf.table;
        this.position = "left";
        this.legendName = this.name = "Graph Name";
        this.rowSelection = null;
        this.rowSelection = this.table.getSelectedRows();
        this.x_series_col = this.table.getSelectedColumn();
        this.datachoice_panel = new JPanel();
        this.datachoice_panel.setLayout(new FlowLayout());
        this.datachoice_panel.setSize(20, 50);
        this.datachoice_max = new JButton("max");
        this.datachoice_max.addActionListener(this.max_listener);
        this.datachoice_START = new JTextField();
        this.datachoice_START.setPreferredSize(new Dimension(40, 14));
        this.datachoice_START.addMouseListener(this.dataSTARTListener);
        this.datachoice_START.getDocument().addDocumentListener(this.d_start_listener);
        this.datachoice_END = new JTextField();
        this.datachoice_END.setPreferredSize(new Dimension(40, 14));
        this.datachoice_END.addMouseListener(this.dataENDListener);
        this.datachoice_END.getDocument().addDocumentListener(this.d_end_listener);
        this.datachoice_panel.add(this.datachoice_END);
        this.datachoice_panel.add(this.datachoice_max);
        this.createPanel();
    }

    public void createPanel() {
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new FlowLayout());
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new FlowLayout());
        this.addButton = new JButton();
        this.remButton = new JButton();
        this.plotButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.customizeButton = new JButton("customize");
        this.upButton.setIcon(this.up_icon);
        this.downButton.setIcon(this.down_icon);
        this.plotButton.setIcon(this.plot_icon);
        this.addButton.setIcon(this.add_icon);
        this.remButton.setIcon(this.rem_icon);
        this.plotButton.setToolTipText("plot graph");
        this.upButton.setToolTipText("move up");
        this.downButton.setToolTipText("move down");
        this.addButton.setToolTipText("add graph");
        this.remButton.setToolTipText("remove button");
        this.invBox = new JCheckBox("invert axis");
        this.isXAxis = new JRadioButton("set X");
        this.isXAxis.addActionListener(this.isXListener);
        this.addButton.setBorder(new SoftBevelBorder(0));
        this.addButton.setPreferredSize(new Dimension(20, 14));
        this.addButton.addActionListener(this.addListener);
        this.remButton.addActionListener(this.removeListener);
        this.upButton.addActionListener(this.upListener);
        this.downButton.addActionListener(this.downListener);
        this.customizeButton.addActionListener(this.customize_listener);
        this.remButton.setBorder(new SoftBevelBorder(0));
        this.remButton.setPreferredSize(new Dimension(20, 14));
        this.upButton.setBorder(new SoftBevelBorder(0));
        this.upButton.setPreferredSize(new Dimension(20, 14));
        this.plotButton.setBorder(new SoftBevelBorder(0));
        this.plotButton.setPreferredSize(new Dimension(20, 14));
        this.downButton.setBorder(new SoftBevelBorder(0));
        this.downButton.setPreferredSize(new Dimension(20, 14));
        this.colorchoice = new JComboBox<String>(this.colors);
        this.colorchoice.setPreferredSize(new Dimension(40, 14));
        this.colorchoice.setSelectedIndex(0);
        this.typechoice = new JComboBox<String>(this.types);
        this.typechoice.setPreferredSize(new Dimension(40, 14));
        this.typechoice.setSelectedIndex(0);
        this.poschoice = new JComboBox<String>(this.positions);
        this.poschoice.setPreferredSize(new Dimension(40, 14));
        this.poschoice.setSelectedIndex(0);
        this.poschoice.addActionListener(this.rendererListener);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("CANCEL");
        JLabel setNameLabel = new JLabel("        Name:");
        JLabel setColumnLabel = new JLabel("  Set Column:");
        JLabel setLegendLabel = new JLabel("Legend Entry:");
        this.nameLabel = new JLabel();
        String[] column = new String[this.table.getColumnCount()];
        Class<?> test = this.table.getValueAt(0, 0).getClass();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (this.plotType == 0) {
                if (i != 0) {
                    column[i] = this.table.getColumnName(i);
                    continue;
                }
                column[i] = "---";
                continue;
            }
            column[i] = this.table.getColumnName(i);
        }
        this.setColumn = new JComboBox<String>(column);
        this.setColumn.setPreferredSize(new Dimension(40, 14));
        this.setColumn.setSelectedIndex(1);
        this.nameLabel.setText((String)this.setColumn.getSelectedItem());
        String name = (String)this.setColumn.getSelectedItem();
        this.setName = new JTextField(name, 14);
        this.setName.setPreferredSize(new Dimension(40, 14));
        this.setLegend = new JTextField(name, 14);
        this.setLegend.setPreferredSize(new Dimension(40, 14));
        namePanel.add(setNameLabel);
        namePanel.add(this.setName);
        legendPanel.add(setLegendLabel);
        legendPanel.add(this.setLegend);
        this.datapanel.setLayout(new FlowLayout());
        this.graphpanel.setLayout(new FlowLayout());
        this.graphpanel.add(this.setColumn);
        this.graphpanel.add(this.poschoice);
        this.graphpanel.add(this.typechoice);
        this.graphpanel.add(this.colorchoice);
        this.datapanel.add(this.nameLabel);
        this.buttonpanel.add(okButton);
        this.buttonpanel.add(cancelButton);
        this.cr_dlg = new CustomizeRendererDlg();
        this.colorlabel = new ColorLabel(this.cr_dlg.shape_fill, this.cr_dlg.outline_color, this.getSeriesShape());
    }

    public void applyTSProperties() {
        this.selectedColumn = this.setColumn.getSelectedIndex();
        this.ts = new TimeSeries((Comparable)((Object)this.getLegendName()), Second.class);
        for (int i = this.getTimeSTART(); i <= this.getTimeEND(); ++i) {
            Attribute.Calendar time = (Attribute.Calendar)this.table.getValueAt(i, 0);
            if (this.setColumn.getSelectedItem().equals("---")) continue;
            double value = (Double)this.table.getValueAt(i, this.selectedColumn);
            this.ts.add((RegularTimePeriod)new Second(new Date(time.getTimeInMillis())), value);
        }
        this.cr_dlg.updateColors();
    }

    public void applyXYProperties() {
        this.selectedColumn = this.setColumn.getSelectedIndex();
        this.xys = new XYSeries((Comparable)((Object)this.getLegendName()));
        for (int i = this.d_range[0]; i <= this.d_range[1]; ++i) {
            this.xys.add(this.cxyconf.sorted_Row[i].col[this.x_series_col], this.cxyconf.sorted_Row[i].col[this.selectedColumn]);
        }
    }

    public TimeSeries getTS() {
        return this.ts;
    }

    public XYSeries getXYS() {
        return this.xys;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    private void setPossibleTimeIntervals() {
        int e;
        int s = this.timechoice_START.getSelectedIndex();
        if (s >= (e = this.timechoice_END.getSelectedIndex())) {
            this.timechoice_END.setSelectedIndex(s);
        }
    }

    public boolean isXSeries() {
        return this.is_x_series;
    }

    public boolean getResult() {
        return this.result;
    }

    public JPanel getGraphPanel() {
        return this.datapanel;
    }

    public void setIsXSeries(boolean xseries) {
        this.is_x_series = xseries;
    }

    public void setXSeries(int col) {
        this.x_series_col = col;
    }

    public int getXSeriesCol() {
        return this.x_series_col;
    }

    public void setXIntervals(int[] range) {
        this.d_range = range;
    }

    public void setXChanged(boolean state) {
        this.x_changed = state;
    }

    public void setDataSelection() {
        this.rowSelection = this.table.getSelectedRows();
        this.selectedColumn = this.table.getSelectedColumn();
    }

    public void setSelectedColumn(int col) {
        this.selectedColumn = col;
        this.setColumn.setSelectedIndex(col);
        this.nameLabel.setText((String)this.setColumn.getSelectedItem());
    }

    public void setSelectedRows(int[] rows) {
        this.rowSelection = rows;
    }

    public void setLegendName(String legendName) {
        this.legendName = legendName;
        this.setLegend.setText(legendName);
    }

    public void setName(String name) {
        this.name = name;
        this.setName.setText(name);
    }

    public void setPosition(String position) {
        this.position = position;
        this.poschoice.setSelectedItem(position);
    }

    public void setRendererType(int type) {
        this.type = type;
    }

    public void setTimeSTART(int index) {
        this.timechoice_START.setSelectedIndex(index);
    }

    public void setTimeEND(int index) {
        this.timechoice_END.setSelectedIndex(index);
    }

    public void setDataSTART(double d_start) {
        this.data_range_start = d_start;
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(4);
        String s = nf.format(d_start);
        this.datachoice_START.setText(s);
    }

    public void setDataEND(double d_end) {
        this.data_range_end = d_end;
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(4);
        String s = nf.format(d_end);
        this.datachoice_END.setText(s);
    }

    public int getColor() {
        return this.color;
    }

    public String getLegendName() {
        return this.setLegend.getText();
    }

    public String getName() {
        this.name = this.selectedColumn != 0 ? this.table.getColumnName(this.selectedColumn) : this.name;
        return this.name;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public int[] getSelectedRows() {
        return this.rowSelection;
    }

    public String getPosition() {
        return (String)this.getPosChoice().getSelectedItem();
    }

    public int getRendererType() {
        return this.type;
    }

    public int getTimeSTART() {
        return this.timechoice_START.getSelectedIndex();
    }

    public int getTimeEND() {
        return this.timechoice_END.getSelectedIndex();
    }

    public double readDataSTART() {
        String text = this.datachoice_START.getText();
        double d_start = new Double(text);
        return d_start;
    }

    public double getDataSTART() {
        return this.data_range_start;
    }

    public double getDataEND() {
        return this.data_range_end;
    }

    public double readDataEND() {
        double d_end = new Double(this.datachoice_END.getText());
        return d_end;
    }

    public boolean axisInverted() {
        return this.invBox.isSelected();
    }

    public JCheckBox getInvBox() {
        return this.invBox;
    }

    public JToggleButton getIsXAxisButton() {
        return this.isXAxis;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public JComboBox getPosChoice() {
        return this.poschoice;
    }

    public JComboBox getTypeChoice() {
        return this.typechoice;
    }

    public JComboBox getColorChoice() {
        return this.colorchoice;
    }

    public JTextField getLegendField() {
        return this.setLegend;
    }

    public JComboBox getDataChoice() {
        return this.setColumn;
    }

    public JComboBox getTimeChoiceSTART() {
        return this.timechoice_START;
    }

    public JComboBox getTimeChoiceEND() {
        return this.timechoice_END;
    }

    public JTextField getDataChoiceSTART() {
        return this.datachoice_START;
    }

    public JTextField getDataChoiceEND() {
        return this.datachoice_END;
    }

    public JButton getMaxButton() {
        return this.datachoice_max;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getRemButton() {
        return this.remButton;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public JButton getPlotButton() {
        return this.plotButton;
    }

    public JButton getCustomizeButton() {
        return this.customizeButton;
    }

    public ColorLabel getColorLabel() {
        return this.colorlabel;
    }

    public void setSeriesStroke(Stroke stroke) {
        this.series_stroke = stroke;
    }

    public void setSeriesShape(Shape shape) {
        this.series_shape = shape;
    }

    public void setSeriesPaint(Color paint) {
        this.series_paint = paint;
        this.cr_dlg.setStrokeButtonColor(paint);
    }

    public void setSeriesFillPaint(Color fill) {
        this.series_fill_paint = fill;
        this.cr_dlg.setFillButtonColor(fill);
    }

    public void setSeriesOutlinePaint(Color out) {
        this.series_outline_paint = out;
        this.cr_dlg.setOutlineButtonColor(out);
    }

    public void setSeriesOutlineStroke(Stroke stroke) {
        this.series_outline_stroke = stroke;
    }

    public void setLinesVisible(boolean flag) {
        this.linesVisible = flag;
    }

    public void setShapesVisible(boolean flag) {
        this.shapesVisible = flag;
    }

    public void setStroke(int type) {
        float width;
        this.stroke_type = type;
        switch (type) {
            case 0: {
                width = 0.0f;
                break;
            }
            case 1: {
                width = 0.5f;
                break;
            }
            case 2: {
                width = 1.0f;
                break;
            }
            case 3: {
                width = 2.0f;
                break;
            }
            case 4: {
                width = 3.0f;
                break;
            }
            case 5: {
                width = 4.0f;
                break;
            }
            case 6: {
                width = 5.0f;
                break;
            }
            case 7: {
                width = 6.0f;
                break;
            }
            case 8: {
                width = 7.0f;
                break;
            }
            case 9: {
                width = 8.0f;
                break;
            }
            case 10: {
                width = 9.0f;
                break;
            }
            case 11: {
                width = 10.0f;
                break;
            }
            case 12: {
                width = 12.0f;
                break;
            }
            default: {
                width = 1.0f;
            }
        }
        this.setSeriesStroke(new BasicStroke(width));
    }

    public void setOutlineStroke(int type) {
        float width;
        this.outline_type = type;
        switch (type) {
            case 0: {
                width = 0.0f;
                break;
            }
            case 1: {
                width = 0.5f;
                break;
            }
            case 2: {
                width = 1.0f;
                break;
            }
            case 3: {
                width = 2.0f;
                break;
            }
            case 4: {
                width = 3.0f;
                break;
            }
            case 5: {
                width = 4.0f;
                break;
            }
            case 6: {
                width = 5.0f;
                break;
            }
            case 7: {
                width = 6.0f;
                break;
            }
            case 8: {
                width = 7.0f;
                break;
            }
            case 9: {
                width = 8.0f;
                break;
            }
            case 10: {
                width = 9.0f;
                break;
            }
            case 11: {
                width = 10.0f;
                break;
            }
            case 12: {
                width = 12.0f;
                break;
            }
            default: {
                width = 1.0f;
            }
        }
        this.setSeriesOutlineStroke(new BasicStroke(width));
    }

    public void setOutlineVisible(boolean state) {
        this.outlineVisible = state;
    }

    public boolean getOutlineVisible() {
        return this.outlineVisible;
    }

    public void setShape(int type, int size) {
        this.shape_type = type;
        this.size_type = size;
        int dim = size;
        int coord = dim / 2;
        switch (type) {
            case 0: {
                this.setSeriesShape(new Rectangle(-coord, -coord, size, size));
                break;
            }
            case 1: {
                Ellipse2D.Double circle = new Ellipse2D.Double(-coord, -coord, size, size);
                this.setSeriesShape(circle);
                break;
            }
            case 2: {
                Shape up_triangle = ShapeUtilities.createUpTriangle((float)size);
                this.setSeriesShape(up_triangle);
                break;
            }
            case 3: {
                Shape down_triangle = ShapeUtilities.createDownTriangle((float)size);
                this.setSeriesShape(down_triangle);
                break;
            }
            case 4: {
                Shape diamond = ShapeUtilities.createDiamond((float)size);
                this.setSeriesShape(diamond);
                break;
            }
            case 5: {
                float t = (float)size * 0.07f;
                Shape diag_cross = ShapeUtilities.createDiagonalCross((float)size, (float)t);
                this.setSeriesShape(diag_cross);
                break;
            }
            case 6: {
                float d = (float)size * 0.07f;
                Shape reg_cross = ShapeUtilities.createRegularCross((float)size, (float)d);
                this.setSeriesShape(reg_cross);
                break;
            }
            default: {
                this.setSeriesShape(new Rectangle());
            }
        }
    }

    public int getStrokeType() {
        return this.stroke_type;
    }

    public int getShapeType() {
        return this.shape_type;
    }

    public int getSizeType() {
        return this.size_type;
    }

    public int getOutlineType() {
        return this.outline_type;
    }

    public Stroke getSeriesStroke() {
        return this.series_stroke;
    }

    public Shape getSeriesShape() {
        return this.series_shape;
    }

    public Color getSeriesPaint() {
        return this.series_paint;
    }

    public Color getSeriesFillPaint() {
        return this.series_fill_paint;
    }

    public Stroke getSeriesOutlineStroke() {
        return this.series_outline_stroke;
    }

    public Color getSeriesOutlinePaint() {
        return this.series_outline_paint;
    }

    public boolean getLinesVisible() {
        return this.linesVisible;
    }

    public boolean getShapesVisible() {
        return this.shapesVisible;
    }

    private void drawLegendItem() {
        JPanel pane = new JPanel();
        pane.setSize(20, 20);
    }

    public void setOutlineSlider(int value) {
        this.cr_dlg.setOutlineSlider(value);
    }

    public void setStrokeSlider(int value) {
        this.cr_dlg.setStrokeSlider(value);
    }

    public void setShapeSlider(int value) {
        this.cr_dlg.setShapeSlider(value);
    }

    public void setShapesVisBox(boolean state) {
        this.cr_dlg.setShapesVisBox(state);
    }

    public void setLinesVisBox(boolean state) {
        this.cr_dlg.setLinesVisBox(state);
    }

    public void setShapeBox(int index) {
        this.cr_dlg.setShapeBox(index);
    }

    private class ItemPanel
    extends JPanel {
        Shape shape;
        Color line_color;
        Color outline_color;
        Color shape_fill;

        public ItemPanel() {
            this.shape = GraphProperties.this.getSeriesShape();
            this.line_color = GraphProperties.this.getSeriesPaint();
            this.outline_color = GraphProperties.this.getSeriesOutlinePaint();
            this.shape_fill = GraphProperties.this.getSeriesFillPaint();
        }

        public void paintComponent(Graphics2D g) {
            g.setColor(this.shape_fill);
            g.fill(this.shape);
            g.setColor(this.outline_color);
            g.draw(this.shape);
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 5, 5);
        }
    }

    public class ColorLabel
    extends JLabel {
        Color shape_fill;
        Color outline_color;
        Color line_color;
        Shape shape;

        public ColorLabel(Color shape_fill, Color outline_color, Shape shape) {
            this.shape_fill = shape_fill;
            this.outline_color = outline_color;
            this.shape = shape;
        }

        public void paint(Graphics2D g) {
            g.setColor(this.shape_fill);
            g.fill(this.shape);
            g.setColor(this.outline_color);
            g.draw(this.shape);
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 15, 15);
        }

        public void setSymbol(Shape shape, Color shape_fill, Color outline_color) {
            this.shape_fill = shape_fill;
            this.outline_color = outline_color;
            this.shape = shape;
        }
    }

    public class ColorButton
    extends JButton {
        Color color;

        public ColorButton(Color color) {
            this.color = color;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.color);
            g.fillRect(1, 1, 14, 14);
            g.setColor(Color.DARK_GRAY);
            g.drawRect(0, 0, 15, 15);
        }

        public void setColor(Color newColor) {
            this.color = newColor;
        }
    }

    private class CustomizeRendererDlg
    extends JDialog {
        boolean result;
        int max;
        String side;
        int side_index;
        int position;
        JDialog thiscrd;
        JPanel optionspanel;
        JPanel colorpanel;
        JPanel buttonpanel;
        Color line_color;
        Color shape_fill;
        Color outline_color;
        JLabel renderer_label;
        JLabel stroke_label;
        JLabel shape_label;
        JLabel paint_label;
        JLabel outline_stroke_label;
        JLabel outline_paint_label;
        JLabel lines_visible_label;
        JLabel shapes_visible_label;
        JLabel fill_label;
        JLabel shape_size_label;
        JComboBox renderer_box;
        JComboBox stroke_box;
        JComboBox shape_box;
        JComboBox paint_box;
        JComboBox outline_stroke_box;
        JComboBox outline_paint_box;
        JComboBox fill_box;
        JCheckBox shapes_vis_box;
        JCheckBox lines_vis_box;
        JComboBox shape_size_box;
        JSlider stroke_slider;
        JSlider shape_slider;
        JSlider outline_slider;
        JSeparator divider;
        JButton stroke_button;
        JButton fill_button;
        JButton outline_button;
        JButton ok_button;
        JButton apply_button;
        JButton cancel_button;
        final String[] SHAPES;
        final String[] COLORS;
        final String[] SHAPE_COLORS;
        final String[] RENDERER;
        final int MIN = 0;
        final int MAX = 12;
        final int STROKE = 2;
        final int SHAPE = 5;
        final int OUTLINE = 1;
        ActionListener ok;
        ActionListener apply;
        ActionListener stroke_button_listener;
        ActionListener fill_button_listener;
        ActionListener outline_button_listener;
        ActionListener cancel;

        public CustomizeRendererDlg() {
            super(GraphProperties.this.parent, "Customize Series Paint", true);
            this.result = false;
            this.thiscrd = this;
            this.SHAPES = new String[]{"Square", "Circle", "Triangle up", "Triangle down", "Diamond", "Cross diagonal", "Cross regular"};
            this.COLORS = new String[]{"custom", "red", "blue", "green", "black", "magenta", "cyan", "yellow", "gray", "orange", "lightgray", "pink"};
            this.SHAPE_COLORS = new String[]{"custom", "white", "red", "blue", "green", "black", "magenta", "cyan", "yellow", "gray", "orange", "lightgray", "pink"};
            this.RENDERER = new String[]{"Line and Shape", "Bar", "Area", "Step", "StepArea", "Difference"};
            this.MIN = 0;
            this.MAX = 12;
            this.STROKE = 2;
            this.SHAPE = 5;
            this.OUTLINE = 1;
            this.ok = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphProperties.this.setStroke(CustomizeRendererDlg.this.stroke_slider.getValue());
                    GraphProperties.this.setShape(CustomizeRendererDlg.this.shape_box.getSelectedIndex(), CustomizeRendererDlg.this.shape_slider.getValue());
                    GraphProperties.this.setSeriesPaint(CustomizeRendererDlg.this.line_color);
                    GraphProperties.this.setSeriesFillPaint(CustomizeRendererDlg.this.shape_fill);
                    GraphProperties.this.setSeriesOutlinePaint(CustomizeRendererDlg.this.outline_color);
                    GraphProperties.this.setOutlineStroke(CustomizeRendererDlg.this.outline_slider.getValue());
                    GraphProperties.this.setLinesVisible(CustomizeRendererDlg.this.lines_vis_box.isSelected());
                    GraphProperties.this.setShapesVisible(CustomizeRendererDlg.this.shapes_vis_box.isSelected());
                    CustomizeRendererDlg.this.result = true;
                    GraphProperties.this.colorlabel.setSymbol(GraphProperties.this.getSeriesShape(), CustomizeRendererDlg.this.shape_fill, CustomizeRendererDlg.this.outline_color);
                    if (GraphProperties.this.plotType == 0) {
                        GraphProperties.this.ctsconf.plotAllGraphs();
                    }
                    if (GraphProperties.this.plotType == 1) {
                        GraphProperties.this.cxyconf.plotAllGraphs();
                    }
                    CustomizeRendererDlg.this.setVisible(false);
                    CustomizeRendererDlg.this.updateColors();
                }
            };
            this.apply = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphProperties.this.setStroke(CustomizeRendererDlg.this.stroke_slider.getValue());
                    GraphProperties.this.setShape(CustomizeRendererDlg.this.shape_box.getSelectedIndex(), CustomizeRendererDlg.this.shape_slider.getValue());
                    GraphProperties.this.setSeriesPaint(CustomizeRendererDlg.this.line_color);
                    GraphProperties.this.setSeriesFillPaint(CustomizeRendererDlg.this.shape_fill);
                    GraphProperties.this.setSeriesOutlinePaint(CustomizeRendererDlg.this.outline_color);
                    GraphProperties.this.setOutlineStroke(CustomizeRendererDlg.this.outline_slider.getValue());
                    GraphProperties.this.setLinesVisible(CustomizeRendererDlg.this.lines_vis_box.isSelected());
                    GraphProperties.this.setShapesVisible(CustomizeRendererDlg.this.shapes_vis_box.isSelected());
                    CustomizeRendererDlg.this.result = true;
                    if (GraphProperties.this.plotType == 0) {
                        GraphProperties.this.ctsconf.plotAllGraphs();
                    }
                    if (GraphProperties.this.plotType == 1) {
                        GraphProperties.this.cxyconf.plotAllGraphs();
                    }
                    CustomizeRendererDlg.this.updateColors();
                }
            };
            this.stroke_button_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color new_line_color = JColorChooser.showDialog(CustomizeRendererDlg.this.thiscrd, "Choose Line Color", CustomizeRendererDlg.this.line_color);
                    if (new_line_color != null) {
                        CustomizeRendererDlg.this.line_color = new_line_color;
                    }
                    CustomizeRendererDlg.this.stroke_button.setBackground(CustomizeRendererDlg.this.line_color);
                }
            };
            this.fill_button_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color new_shape_fill = JColorChooser.showDialog(CustomizeRendererDlg.this.thiscrd, "Choose Shape Color", CustomizeRendererDlg.this.shape_fill);
                    if (new_shape_fill != null) {
                        CustomizeRendererDlg.this.shape_fill = new_shape_fill;
                    }
                    CustomizeRendererDlg.this.fill_button.setBackground(CustomizeRendererDlg.this.shape_fill);
                }
            };
            this.outline_button_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color new_outline_color = JColorChooser.showDialog(CustomizeRendererDlg.this.thiscrd, "Choose Outline Color", CustomizeRendererDlg.this.outline_color);
                    if (new_outline_color != null) {
                        CustomizeRendererDlg.this.outline_color = new_outline_color;
                    }
                    CustomizeRendererDlg.this.outline_button.setBackground(CustomizeRendererDlg.this.outline_color);
                }
            };
            this.cancel = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizeRendererDlg.this.setVisible(false);
                }
            };
            this.setIconImages(JAMSTools.getJAMSIcons());
            Point parentloc = GraphProperties.this.parent.getLocation();
            this.setLocation(parentloc.x + 50, parentloc.y + 50);
            try {
                this.line_color = GraphProperties.this.getSeriesPaint();
                this.shape_fill = GraphProperties.this.getSeriesFillPaint();
                this.outline_color = GraphProperties.this.getSeriesOutlinePaint();
            }
            catch (Exception cce) {
                this.line_color = Color.RED;
                this.shape_fill = Color.RED;
                this.outline_color = Color.GRAY;
            }
            this.createPanel();
        }

        public void updateColors() {
            this.line_color = GraphProperties.this.getSeriesPaint();
            this.shape_fill = GraphProperties.this.getSeriesFillPaint();
            this.outline_color = GraphProperties.this.getSeriesOutlinePaint();
            this.stroke_button.setBackground(this.line_color);
            this.fill_button.setBackground(this.shape_fill);
            this.outline_button.setBackground(this.outline_color);
        }

        public void setStrokeButtonColor(Color lc) {
            this.stroke_button.setBackground(lc);
        }

        public void setFillButtonColor(Color fc) {
            this.fill_button.setBackground(fc);
        }

        public void setOutlineButtonColor(Color oc) {
            this.outline_button.setBackground(oc);
        }

        public void setOutlineSlider(int value) {
            this.outline_slider.setValue(value);
        }

        public void setStrokeSlider(int value) {
            this.stroke_slider.setValue(value);
        }

        public void setShapeSlider(int value) {
            this.shape_slider.setValue(value);
        }

        public void setShapesVisBox(boolean state) {
            this.shapes_vis_box.setSelected(state);
        }

        public void setLinesVisBox(boolean state) {
            this.lines_vis_box.setSelected(state);
        }

        public void setShapeBox(int index) {
            this.shape_box.setSelectedIndex(index);
        }

        void createPanel() {
            this.optionspanel = new JPanel();
            this.colorpanel = new JPanel();
            this.buttonpanel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            BorderLayout brl = new BorderLayout();
            GridBagLayout option_gbl = new GridBagLayout();
            GridBagLayout button_gbl = new GridBagLayout();
            this.setLayout(brl);
            this.optionspanel.setLayout(option_gbl);
            this.ok_button = new JButton("OK");
            this.cancel_button = new JButton("Cancel");
            this.ok_button.addActionListener(this.ok);
            this.cancel_button.addActionListener(this.cancel);
            this.apply_button = new JButton("apply");
            this.apply_button.addActionListener(this.apply);
            this.stroke_label = new JLabel("Stroke:");
            this.shape_label = new JLabel("Shape:");
            this.shape_box = new JComboBox<String>(this.SHAPES);
            this.shape_box.setSelectedIndex(0);
            this.paint_label = new JLabel("Color:");
            this.paint_box = new JComboBox<String>(this.COLORS);
            this.paint_box.setSelectedIndex(1);
            this.outline_stroke_label = new JLabel("Outline Stroke:");
            this.outline_paint_label = new JLabel("Outline Color:");
            this.outline_paint_box = new JComboBox<String>(this.SHAPE_COLORS);
            this.outline_paint_box.setSelectedIndex(3);
            this.fill_label = new JLabel("Color:");
            this.fill_box = new JComboBox<String>(this.SHAPE_COLORS);
            this.fill_box.setSelectedIndex(2);
            this.shape_size_label = new JLabel("Size");
            this.lines_visible_label = new JLabel("Lines");
            this.lines_vis_box = new JCheckBox();
            this.lines_vis_box.setSelected(true);
            this.shapes_visible_label = new JLabel("Shapes");
            this.shapes_vis_box = new JCheckBox();
            this.shapes_vis_box.setSelected(true);
            this.stroke_slider = new JSlider(0, 0, 12, 2);
            this.shape_slider = new JSlider(0, 0, 12, 5);
            this.outline_slider = new JSlider(0, 0, 12, 1);
            this.stroke_slider.setMajorTickSpacing(4);
            this.stroke_slider.setMinorTickSpacing(1);
            this.stroke_slider.setPaintTicks(true);
            this.stroke_slider.setPaintLabels(true);
            this.stroke_slider.setSnapToTicks(true);
            this.shape_slider.setMajorTickSpacing(4);
            this.shape_slider.setMinorTickSpacing(1);
            this.shape_slider.setPaintTicks(true);
            this.shape_slider.setPaintLabels(true);
            this.shape_slider.setSnapToTicks(true);
            this.outline_slider.setMajorTickSpacing(4);
            this.outline_slider.setMinorTickSpacing(1);
            this.outline_slider.setPaintTicks(true);
            this.outline_slider.setPaintLabels(true);
            this.outline_slider.setSnapToTicks(true);
            this.divider = new JSeparator(1);
            this.stroke_button = new JButton("color");
            this.fill_button = new JButton("color");
            this.outline_button = new JButton("color");
            this.stroke_button.setBackground(this.line_color);
            this.fill_button.setBackground(this.shape_fill);
            this.outline_button.setBackground(this.outline_color);
            this.stroke_button.setSize(15, 15);
            this.fill_button.setSize(15, 15);
            this.outline_button.setSize(15, 15);
            this.stroke_button.addActionListener(this.stroke_button_listener);
            this.fill_button.addActionListener(this.fill_button_listener);
            this.outline_button.addActionListener(this.outline_button_listener);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)new JLabel("Line"), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)new JLabel("Symbol"), (int)4, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.stroke_label, (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.stroke_slider, (int)1, (int)1, (int)1, (int)2, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.paint_label, (int)0, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.stroke_button, (int)1, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.lines_visible_label, (int)0, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.lines_vis_box, (int)1, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.shapes_visible_label, (int)0, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.shapes_vis_box, (int)1, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.divider, (int)2, (int)1, (int)1, (int)8, (double)1.0, (double)1.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.shape_label, (int)4, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.shape_box, (int)5, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.shape_size_label, (int)4, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.shape_slider, (int)5, (int)2, (int)1, (int)2, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.fill_label, (int)4, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.fill_button, (int)5, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.outline_stroke_label, (int)4, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.outline_slider, (int)5, (int)5, (int)1, (int)2, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.outline_paint_label, (int)4, (int)7, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.optionspanel, (GridBagLayout)option_gbl, (Component)this.outline_button, (int)5, (int)7, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.buttonpanel, (GridBagLayout)button_gbl, (Component)this.ok_button, (int)0, (int)0, (int)1, (int)1, (double)1.0, (double)1.0);
            GUIHelper.addGBComponent((Container)this.buttonpanel, (GridBagLayout)button_gbl, (Component)this.cancel_button, (int)1, (int)0, (int)1, (int)1, (double)1.0, (double)1.0);
            GUIHelper.addGBComponent((Container)this.buttonpanel, (GridBagLayout)button_gbl, (Component)this.apply_button, (int)2, (int)0, (int)1, (int)1, (double)1.0, (double)1.0);
            this.add((Component)this.optionspanel, "Center");
            this.add((Component)this.buttonpanel, "South");
            GraphProperties.this.setStroke(this.stroke_slider.getValue());
            GraphProperties.this.setShape(this.shape_box.getSelectedIndex(), this.shape_slider.getValue());
            GraphProperties.this.setOutlineStroke(this.outline_slider.getValue());
            GraphProperties.this.setLinesVisible(this.lines_vis_box.isSelected());
            GraphProperties.this.setShapesVisible(this.shapes_vis_box.isSelected());
            this.handleGUI();
            this.pack();
            this.setVisible(false);
        }

        private void handleGUI() {
            if (GraphProperties.this.getRendererType() == 0) {
                this.stroke_slider.setEnabled(true);
                this.shape_box.setEnabled(true);
                this.stroke_button.setEnabled(true);
                this.outline_slider.setEnabled(true);
                this.outline_button.setEnabled(true);
                this.fill_button.setEnabled(true);
                this.shapes_vis_box.setEnabled(true);
                this.lines_vis_box.setEnabled(true);
                this.shape_slider.setEnabled(true);
            }
            if (GraphProperties.this.getRendererType() == 2) {
                this.stroke_slider.setEnabled(false);
                this.shape_box.setEnabled(false);
                this.stroke_button.setEnabled(true);
                this.outline_slider.setEnabled(false);
                this.outline_button.setEnabled(false);
                this.fill_button.setEnabled(false);
                this.shapes_vis_box.setEnabled(false);
                this.lines_vis_box.setEnabled(false);
                this.shape_slider.setEnabled(false);
            }
            if (GraphProperties.this.getRendererType() == 5) {
                this.stroke_slider.setEnabled(true);
                this.shape_box.setEnabled(true);
                this.stroke_button.setEnabled(true);
                this.outline_slider.setEnabled(false);
                this.outline_button.setEnabled(false);
                this.fill_button.setEnabled(false);
                this.shapes_vis_box.setEnabled(true);
                this.lines_vis_box.setEnabled(true);
                this.shape_slider.setEnabled(true);
            }
            if (GraphProperties.this.getRendererType() == 1 || GraphProperties.this.getRendererType() == 3 || GraphProperties.this.getRendererType() == 4) {
                this.stroke_slider.setEnabled(false);
                this.shape_box.setEnabled(false);
                this.stroke_button.setEnabled(true);
                this.outline_slider.setEnabled(false);
                this.outline_button.setEnabled(false);
                this.fill_button.setEnabled(false);
                this.shapes_vis_box.setEnabled(false);
                this.lines_vis_box.setEnabled(false);
                this.shape_slider.setEnabled(false);
            }
        }
    }
}

