/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSGUIComponent;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

@JAMSComponentDescription(title="SimpleXYPlot", author="Sven Kralisch", description="This component creates a graphical plot of x/y data, e.g. evaptranspiration plotted against temperature.", date="2018-09-14", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2018-09-14", comment="Some improvements")})
public class SimpleXYPlot
extends JAMSGUIComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for plot", defaultValue="Plot Title")
    public Attribute.StringArray plotTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for x axis", defaultValue="x axis")
    public Attribute.String xAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for y axis", defaultValue="y axis")
    public Attribute.String yAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Values on x axis")
    public Attribute.Double xValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Values on y axis")
    public Attribute.Double[] yValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Flag for disabling or enabling the plot", defaultValue="true")
    public Attribute.Boolean paint;
    private transient XYPlot plot;
    private transient XYSeries[] dataset;
    private transient JPanel panel;
    transient JFreeChart chart;
    transient JButton saveButton;
    int i;
    int graphCountLeft = 0;
    int graphCountRight = 0;
    HashMap<Integer, Color> colorTable = new HashMap();

    public SimpleXYPlot() {
        this.colorTable.put(0, Color.red);
        this.colorTable.put(1, Color.blue);
        this.colorTable.put(2, Color.green);
        this.colorTable.put(3, Color.pink);
        this.colorTable.put(4, Color.magenta);
        this.colorTable.put(5, Color.cyan);
        this.colorTable.put(6, Color.yellow);
        this.colorTable.put(7, Color.green);
        this.colorTable.put(8, Color.gray);
        this.colorTable.put(9, Color.lightGray);
        this.colorTable.put(10, Color.black);
        this.panel = null;
    }

    private void initDataSets() {
        this.dataset = new XYSeries[this.yValue.length];
        for (int i = 0; i < this.dataset.length; ++i) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            this.dataset[i] = new XYSeries((Comparable)((Object)this.plotTitle.getValue()[i]));
            this.plot.setDataset(i, (XYDataset)new XYSeriesCollection(this.dataset[i]));
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesVisible(0, false);
            renderer.setSeriesPaint(0, (Paint)this.colorTable.get(i));
            this.plot.setRenderer(i, (XYItemRenderer)renderer);
        }
    }

    private JPanel createPanel() {
        this.plot = new XYPlot();
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(this.xAxisTitle.getValue()));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(this.yAxisTitle.getValue()));
        this.chart = new JFreeChart((Plot)this.plot);
        ChartPanel chartPanel = new ChartPanel(this.chart, true);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)chartPanel, "Center");
        this.chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.chart.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        return this.panel;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            return this.createPanel();
        }
        return this.panel;
    }

    public void init() {
        this.initDataSets();
    }

    public void run() {
        if (this.dataset == null) {
            this.initDataSets();
        }
        if (this.paint == null || this.paint.getValue()) {
            for (int i = 0; i < this.dataset.length; ++i) {
                this.dataset[i].add(this.xValue.getValue(), this.yValue[i].getValue());
            }
        }
    }

    public void cleanup() {
    }

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        this.createPanel();
        for (int i = 0; i < this.dataset.length; ++i) {
            int n = objIn.readInt();
            for (int j = 0; j < n; ++j) {
                XYDataItem item = this.dataset[i].getDataItem(j);
                double x = objIn.readDouble();
                double y = objIn.readDouble();
                this.dataset[i].add(x, y);
            }
        }
    }

    private void writeObject(ObjectOutputStream objOut) throws IOException {
        objOut.defaultWriteObject();
        for (int i = 0; i < this.dataset.length; ++i) {
            int n = this.dataset[i].getItemCount();
            objOut.writeInt(n);
            for (int j = 0; j < n; ++j) {
                XYDataItem item = this.dataset[i].getDataItem(j);
                objOut.writeDouble(item.getX().doubleValue());
                objOut.writeDouble(item.getY().doubleValue());
            }
        }
    }
}

