/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.MultiPolygon;
import jams.components.gui.MapCollection;
import jams.components.io.ShapeTool;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSGUIComponent;
import jams.model.JAMSVarDescription;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.gui.swing.JMapPane;
import org.geotools.gui.swing.event.SelectionChangeListener;
import org.geotools.gui.swing.event.SelectionChangedEvent;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@JAMSComponentDescription(title="MapCreator", author="Christian Schwartze", description="Viewer component for JAMS entities, parameter and optional vector layers.", date="2010-10-22")
public class MapCreator
extends JAMSGUIComponent
implements MouseListener {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of SLD-File containing layer style information")
    public Attribute.String stylesFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current time step")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of a style in the SLD-File")
    public Attribute.Integer styleID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of hru attribute to add for mapping")
    public Attribute.StringArray showAttr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of ranges for classification attribute")
    public Attribute.StringArray numOfRanges;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Color shading the ranges")
    public Attribute.StringArray rangeColor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of shapefile to add as a layer to the map")
    public Attribute.String shapeFileName1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of shapefile to add as a layer to the map")
    public Attribute.String shapeFileName2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of shapefile to add as a layer to the map")
    public Attribute.String shapeFileName3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Colors for extra shapefiles")
    public Attribute.StringArray shapeColors;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Original shape file name")
    public Attribute.String baseShape;
    private transient JPanel panel;
    private transient JPanel waitPanel;
    private transient JLabel timeLabel;
    protected transient GISPanel gispanel;
    private transient DefaultMapLayer[] optLayers = new DefaultMapLayer[3];
    private transient MapCollection[] mc;
    private int numOfParams;
    private int infoidx;
    private final String mapFTypeName = "mapFType";
    private DefaultMutableTreeNode top;
    private DefaultMutableTreeNode last;
    private JTree tree;
    private boolean finished = false;
    private transient DefaultMapContext map;
    private transient JMapPane mp;
    private transient JTextPane info;
    private transient JSplitPane mainSplitPane;
    private transient JSplitPane legendPane;
    public transient JScrollPane treeView;
    private SimpleFeature selectedF = null;
    private CoordinateReferenceSystem crs;
    private transient DefaultMapContext topmap;
    private transient DefaultMapLayer selection = null;
    private Envelope fullExtent;
    private String[] otherLayers;
    private int div_hor;
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    Set<SelectionChangeListener> listenerSet = new HashSet<SelectionChangeListener>();

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.listenerSet.add(listener);
    }

    public void init() {
        try {
            if (this.panel == null) {
                return;
            }
            URL shp = new File(this.baseShape.getValue().split(";")[0]).toURI().toURL();
            ShapefileDataStore shpDs = new ShapefileDataStore(shp);
            this.crs = shpDs.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
            if (this.crs == null) {
                ((JLabel)this.waitPanel.getComponents()[0]).setText("<html><center>No *.PRJ file found for<br>" + shp.getFile() + "<center><html>");
                ((JLabel)this.waitPanel.getComponents()[0]).setIcon(new ImageIcon(this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/error.png")));
                return;
            }
            this.gispanel.removeAll();
            if (this.shapeFileName1 == null) {
                this.shapeFileName1 = this.getModel().getRuntime().getDataFactory().createString();
            }
            if (this.shapeFileName2 == null) {
                this.shapeFileName2 = this.getModel().getRuntime().getDataFactory().createString();
            }
            if (this.shapeFileName3 == null) {
                this.shapeFileName3 = this.getModel().getRuntime().getDataFactory().createString();
            }
            this.otherLayers = new String[]{this.shapeFileName1.getValue(), this.shapeFileName2.getValue(), this.shapeFileName3.getValue()};
            int j = 0;
            for (String s : this.otherLayers) {
                DefaultMapLayer layer = null;
                if (!s.isEmpty()) {
                    try {
                        File shpFile = new File(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.otherLayers[j]);
                        URL shpUrl = shpFile.toURI().toURL();
                        ShapefileDataStore ds = new ShapefileDataStore(shpUrl);
                        List featureNames = ds.getNames();
                        FeatureSource featureSource = ds.getFeatureSource((Name)featureNames.get(0));
                        String geoType = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getType().getName().toString();
                        if (geoType.equals("LineString") || geoType.equals("MultiLineString")) {
                            layer = new DefaultMapLayer(featureSource, this.gispanel.getLineStyle(this.shapeColors.getValue()[j]));
                        } else if (geoType.equals("Point") || geoType.equals("MultiPoint")) {
                            layer = new DefaultMapLayer(featureSource, this.gispanel.getPointStyle(this.shapeColors.getValue()[j]));
                        } else if (geoType.equals("Polygon") || geoType.equals("MultiPolygon")) {
                            layer = new DefaultMapLayer(featureSource, this.gispanel.getSurfaceStyle(this.shapeColors.getValue()[j]));
                        }
                        layer.setTitle(new File(this.otherLayers[j]).getName());
                        this.optLayers[j] = layer;
                    }
                    catch (Exception e) {
                        this.getModel().getRuntime().handle((Throwable)e);
                    }
                }
                ++j;
            }
            this.mp.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MapCreator.this.mp.getState() == 4) {
                        try {
                            MapCreator.this.gispanel.getFeatureInfo(e.getX(), e.getY());
                            for (SelectionChangeListener l : MapCreator.this.listenerSet) {
                                l.selectionChanged(new SelectionChangedEvent((Object)MapCreator.this.mp, null));
                            }
                        }
                        catch (CQLException ex) {
                            MapCreator.this.getModel().getRuntime().handle((Throwable)ex);
                        }
                        catch (IOException ex) {
                            MapCreator.this.getModel().getRuntime().handle((Throwable)ex);
                        }
                    }
                }
            });
            this.gispanel.addToolbar();
            this.numOfParams = this.showAttr.getValue().length;
            this.mc = new MapCollection[this.numOfParams];
            this.getCollections();
            for (int i = 0; i < this.numOfParams; ++i) {
                if (this.mc[i] == null) continue;
                this.gispanel.addMap(this.mc[i]);
                this.infoidx = i;
            }
            for (DefaultMapLayer l : this.optLayers) {
                if (l == null || this.topmap == null) continue;
                this.topmap.addLayer((MapLayer)l);
            }
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
            this.finished = true;
            if (this.topmap == null) {
                this.panel.removeAll();
                JLabel label = new JLabel("No geometry features found in entity set!", 0);
                label.setVerticalTextPosition(3);
                label.setHorizontalTextPosition(0);
                label.setFont(new Font("Dialog", 1, 14));
                this.panel.setLayout(new BorderLayout());
                this.panel.add((Component)label, "Center");
                this.panel.updateUI();
                return;
            }
            this.fullExtent = this.topmap.getAreaOfInterest();
            this.mp.setMapArea((Envelope)this.topmap.getLayerBounds());
            this.div_hor = this.gispanel.getSize().width - this.mainSplitPane.getInsets().right - this.mainSplitPane.getDividerSize() - 150;
            int div_ver = this.gispanel.getSize().height - this.mainSplitPane.getInsets().bottom - this.mainSplitPane.getDividerSize() - 150;
            this.mainSplitPane.setLeftComponent((Component)this.mp);
            this.mainSplitPane.setRightComponent(this.legendPane);
            this.mainSplitPane.setDividerLocation(this.div_hor);
            this.legendPane.setDividerLocation(div_ver);
            this.gispanel.add(this.mainSplitPane);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().sendErrorMsg("An error occured while trying to load geometries from " + new File(this.baseShape.getValue().split(";")[0]).getAbsolutePath() + " (" + ex.getMessage() + ")");
        }
    }

    public void run() {
        if (this.panel == null) {
            return;
        }
        try {
            this.updateCollections();
            this.gispanel.update();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public JPanel getPanel() {
        try {
            this.gispanel = new GISPanel();
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.gispanel, "Center");
        }
        catch (Exception e) {
            this.getModel().getRuntime().handle((Throwable)e);
        }
        if (this.panel == null) {
            this.panel = new JPanel();
            JTextField text = new JTextField("Available only under Windows!");
            text.setEditable(false);
            text.setBorder(null);
            this.panel.add(text);
        }
        return this.panel;
    }

    protected SimpleFeature getSelectedFeature() {
        return this.selectedF;
    }

    private void getCollections() {
        for (int i = 0; i <= this.numOfParams - 1; ++i) {
            FeatureCollection fc = FeatureCollections.newCollection();
            SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
            sftb.setName("mapFType");
            sftb.setCRS(this.crs);
            sftb.add("geo", MultiPolygon.class);
            sftb.add("newAt", Object.class);
            SimpleFeatureType mapFType = sftb.buildFeatureType();
            Iterator hrusIterate = this.hrus.getEntities().iterator();
            TreeSet<Double> s = new TreeSet<Double>();
            Attribute.Entity e = null;
            while (hrusIterate.hasNext()) {
                e = (Attribute.Entity)hrusIterate.next();
                if (!e.existsAttribute("geom")) continue;
                SimpleFeature f = SimpleFeatureBuilder.template((SimpleFeatureType)mapFType, (String)Integer.toString(Double.valueOf(e.getDouble("ID")).intValue()));
                if (e.getGeometry("geom") == null) {
                    this.getModel().getRuntime().sendHalt("no geometry for HRU:" + e.getDouble("ID"));
                }
                f.setAttribute("geo", (Object)e.getGeometry("geom"));
                f.setAttribute("newAt", (Object)e.getDouble(this.showAttr.getValue()[i]));
                fc.add((Feature)f);
                s.add(e.getDouble(this.showAttr.getValue()[i]));
            }
            if (fc.isEmpty()) continue;
            this.mc[i] = new MapCollection(this.showAttr.getValue()[i], (FeatureCollection<SimpleFeatureType, SimpleFeature>)fc, "newAt", this.rangeColor.getValue()[i], Integer.parseInt(this.numOfRanges.getValue()[i]), this.crs);
        }
    }

    private void updateCollections() throws IOException {
        this.top.removeAllChildren();
        this.top.removeFromParent();
        if (this.time != null && this.time.getValue() != null) {
            this.timeLabel.setText(this.time.toString());
        }
        for (int i = 0; i <= this.numOfParams - 1; ++i) {
            FeatureIterator fi = this.mc[i].getMapContext().getLayer(0).getFeatureSource().getFeatures().features();
            while (fi.hasNext()) {
                Feature f = fi.next();
                if (!(f instanceof SimpleFeature)) continue;
                SimpleFeature sf = (SimpleFeature)f;
                int id = Integer.parseInt(sf.getID());
                Attribute.Entity e = this.hrus.getEntity((long)id);
                double value = e.getDouble(this.showAttr.getValue()[i]);
                sf.setAttribute("newAt", (Object)value);
            }
            this.mc[i].update();
            DefaultMutableTreeNode mapNode = new DefaultMutableTreeNode(this.mc[i].getDesc());
            this.top.add(mapNode);
            Object[] nodeContent = this.mc[i].getRanges();
            DefaultMutableTreeNode entry = null;
            for (int j = 1; j <= nodeContent.length - 1; ++j) {
                if (nodeContent[j] == null) {
                    nodeContent[j] = nodeContent[j - 1];
                }
                entry = new DefaultMutableTreeNode("<= " + (double)Math.round((Double)nodeContent[j] * 100.0) / 100.0, false);
                mapNode.add(entry);
            }
        }
        DefaultMutableTreeNode layerEntry = null;
        int i = 0;
        for (DefaultMapLayer l : this.optLayers) {
            if (l != null) {
                layerEntry = new DefaultMutableTreeNode(this.optLayers[i].getTitle());
                this.top.add(layerEntry);
            }
            ++i;
        }
        this.tree.setModel(new DefaultTreeModel(this.top));
        this.tree.invalidate();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mp.getState() == 4) {
            JOptionPane.showMessageDialog(null, "selection");
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.optLayers = new DefaultMapLayer[3];
    }

    public class GISPanel
    extends JPanel {
        private StyleBuilder sb;

        private Style createFromSLD(String str) {
            File sld = new File(str);
            try {
                SLDParser stylereader = new SLDParser(styleFactory, sld);
                Style[] style = stylereader.readXML();
                return style[0];
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
                return null;
            }
        }

        public Style getLineStyle(String c) {
            this.sb = new StyleBuilder();
            LineSymbolizer ls = this.sb.createLineSymbolizer(Color.decode("#" + c), 2.0);
            return this.sb.createStyle((Symbolizer)ls);
        }

        public Style getPointStyle(String c) {
            this.sb = new StyleBuilder();
            Mark pointMarker = this.sb.createMark("square", Color.decode("#" + c));
            PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, pointMarker, null, 0.0, 7.0, 0.0));
            return this.sb.createStyle((Symbolizer)ps);
        }

        public Style getSurfaceStyle(String c) {
            this.sb = new StyleBuilder();
            PolygonSymbolizer pgs = this.sb.createPolygonSymbolizer(Color.decode("#" + c), Color.decode("#000000"), 1.0);
            return this.sb.createStyle((Symbolizer)pgs);
        }

        public void addMap(MapCollection m) {
            try {
                MapCreator.this.topmap.removeLayer((MapLayer)MapCreator.this.selection);
                for (DefaultMapLayer l : MapCreator.this.optLayers) {
                    if (l == null) continue;
                    MapCreator.this.topmap.removeLayer((MapLayer)l);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MapCreator.this.map = m.getMapContext();
            MapCreator.this.topmap = MapCreator.this.map;
            for (DefaultMapLayer l : MapCreator.this.optLayers) {
                if (l == null) continue;
                MapCreator.this.topmap.addLayer((MapLayer)l);
            }
            MapCreator.this.mp.setContext((MapContext)MapCreator.this.map);
            MapCreator.this.mp.setRenderer((GTRenderer)new StreamingRenderer());
        }

        public void addToolbar() {
            URL url_zoomIn = this.getClass().getResource("resources/zoom_in.png");
            ImageIcon icon_zoomIn = new ImageIcon(url_zoomIn);
            URL url_zoomOut = this.getClass().getResource("resources/zoom_out.png");
            ImageIcon icon_zoomOut = new ImageIcon(url_zoomOut);
            URL url_zoomExtent = this.getClass().getResource("resources/zoom_extent.png");
            ImageIcon icon_zoomExtent = new ImageIcon(url_zoomExtent);
            URL url_pan = this.getClass().getResource("resources/pan.png");
            ImageIcon icon_pan = new ImageIcon(url_pan);
            URL url_select = this.getClass().getResource("resources/select.png");
            ImageIcon icon_select = new ImageIcon(url_select);
            URL url_export = this.getClass().getResource("resources/export.png");
            ImageIcon icon_export = new ImageIcon(url_export);
            JPanel buttons = new JPanel();
            JButton zoomInButton = new JButton(icon_zoomIn);
            final Cursor defaultCursor = new Cursor(0);
            zoomInButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator.this.mp.setCursor(defaultCursor);
                    MapCreator.this.mp.setState(1);
                }
            });
            buttons.add(zoomInButton);
            JButton zoomOutButton = new JButton(icon_zoomOut);
            zoomOutButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator.this.mp.setCursor(defaultCursor);
                    MapCreator.this.mp.setState(2);
                }
            });
            buttons.add(zoomOutButton);
            JButton zoomExtentButton = new JButton(icon_zoomExtent);
            zoomExtentButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator.this.mp.setCursor(defaultCursor);
                    MapCreator.this.mp.setMapArea(MapCreator.this.fullExtent);
                    MapCreator.this.mp.setReset(true);
                    MapCreator.this.mp.repaint();
                }
            });
            buttons.add(zoomExtentButton);
            JButton panButton = new JButton(icon_pan);
            final Cursor panCursor = new Cursor(13);
            panButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator.this.mp.setCursor(panCursor);
                    MapCreator.this.mp.setState(3);
                }
            });
            buttons.add(panButton);
            JButton selectButton = new JButton(icon_select);
            final Cursor selectCursor = new Cursor(1);
            selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator.this.mp.setCursor(selectCursor);
                    MapCreator.this.mp.setState(4);
                }
            });
            buttons.add(selectButton);
            JButton exportButton = new JButton(icon_export);
            exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapCreator.this.mp.setCursor(defaultCursor);
                    try {
                        int idx = MapCreator.this.last == null || MapCreator.this.last.isRoot() ? 0 : (MapCreator.this.last.isLeaf() ? MapCreator.this.top.getIndex(MapCreator.this.last.getParent()) : (MapCreator.this.top.isNodeChild(MapCreator.this.last) ? MapCreator.this.top.getIndex(MapCreator.this.last) : MapCreator.this.top.getIndex(MapCreator.this.top)));
                        ShapeTool exportPanel = new ShapeTool(MapCreator.this.mc[idx], MapCreator.this.baseShape, MapCreator.this.legendPane);
                        MapCreator.this.mainSplitPane.setRightComponent(exportPanel);
                        MapCreator.this.mainSplitPane.setDividerLocation(MapCreator.this.div_hor);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "For export please select an attribute layer!");
                    }
                }
            });
            buttons.add(exportButton);
            this.add((Component)buttons, "North");
        }

        public void update() {
            MapCreator.this.mp.setReset(true);
            MapCreator.this.mp.repaint();
        }

        public GISPanel() throws Exception {
            MapCreator.this.mp = new JMapPane();
            MapCreator.this.mp.setCursor(new Cursor(0));
            MapCreator.this.legendPane = new JSplitPane(0);
            MapCreator.this.info = new JTextPane();
            MapCreator.this.info.setContentType("text/html");
            MapCreator.this.info.setText("<html><br><center>No feature selected</center></html>");
            MapCreator.this.info.setEditable(false);
            MapCreator.this.top = new DefaultMutableTreeNode("Map List");
            MapCreator.this.tree = new JTree(MapCreator.this.top);
            MapCreator.this.tree.setCellRenderer(new NodeRenderer());
            MapCreator.this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)MapCreator.this.tree.getLastSelectedPathComponent();
                    if (node != null) {
                        MapCreator.this.last = node;
                        int idxToTopNode = node.isLeaf() ? MapCreator.this.top.getIndex(node.getParent()) : MapCreator.this.top.getIndex(node);
                        if (e.getClickCount() == 1 & idxToTopNode >= 0 & (MapCreator.this.top.isNodeChild(node) || node.isLeaf())) {
                            try {
                                GISPanel.this.addMap(MapCreator.this.mc[idxToTopNode]);
                                MapCreator.this.mp.setReset(true);
                                MapCreator.this.mp.repaint();
                                if (MapCreator.this.last == null || MapCreator.this.last.isRoot()) {
                                    MapCreator.this.infoidx = 0;
                                } else if (MapCreator.this.last.isLeaf()) {
                                    MapCreator.this.infoidx = MapCreator.this.top.getIndex(MapCreator.this.last.getParent());
                                } else {
                                    MapCreator.this.infoidx = MapCreator.this.top.getIndex(MapCreator.this.last);
                                }
                            }
                            catch (Exception e1) {
                                MapCreator.this.getModel().getRuntime().handle((Throwable)e1);
                            }
                        }
                    }
                }
            });
            MapCreator.this.treeView = new JScrollPane(MapCreator.this.tree);
            JPanel topPanel = new JPanel(new BorderLayout());
            MapCreator.this.timeLabel = new JLabel();
            topPanel.add((Component)MapCreator.this.timeLabel, "North");
            topPanel.add((Component)MapCreator.this.treeView, "Center");
            MapCreator.this.legendPane.setTopComponent(topPanel);
            MapCreator.this.legendPane.setBottomComponent(MapCreator.this.info);
            this.setLayout(new BorderLayout());
            MapCreator.this.waitPanel = new JPanel();
            ImageIcon waiticon = new ImageIcon(MapCreator.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/wait.gif"));
            MapCreator.this.waitPanel.setLayout(new BorderLayout());
            JLabel label = new JLabel("Please wait...!", waiticon, 0);
            label.setVerticalTextPosition(3);
            label.setHorizontalTextPosition(0);
            label.setFont(new Font("Dialog", 1, 14));
            MapCreator.this.waitPanel.add(label);
            MapCreator.this.mainSplitPane = new JSplitPane(1);
            this.add(MapCreator.this.waitPanel);
        }

        private void getFeatureInfo(int a, int b) throws CQLException, IOException {
            block7: {
                double x = a;
                double y = b;
                Rectangle bounds = MapCreator.this.mp.getBounds();
                double width = MapCreator.this.mp.getMapArea().getWidth();
                double height = MapCreator.this.mp.getMapArea().getHeight();
                double mapX = x * width / (double)bounds.width + MapCreator.this.mp.getMapArea().getMinX();
                double mapY = (bounds.getHeight() - y) * height / (double)bounds.height + MapCreator.this.mp.getMapArea().getMinY();
                Filter f1 = CQL.toFilter((String)("CONTAINS(geo, POINT(" + mapX + " " + mapY + "))"));
                int idx = 0;
                try {
                    idx = MapCreator.this.last == null || MapCreator.this.last.isRoot() ? 0 : (MapCreator.this.last.isLeaf() ? MapCreator.this.top.getIndex(MapCreator.this.last.getParent()) : MapCreator.this.top.getIndex(MapCreator.this.last));
                    FeatureCollection result = MapCreator.this.mc[idx].asCollectionDataStore().getFeatureSource(MapCreator.this.mc[idx].asCollectionDataStore().getTypeNames()[0]).getFeatures(f1);
                    if (result.size() == 0) {
                        MapCreator.this.info.setText("<html><br><center>No feature selected</center></html>");
                        try {
                            MapCreator.this.topmap.removeLayer((MapLayer)MapCreator.this.selection);
                        }
                        catch (Exception exception) {}
                        break block7;
                    }
                    MapCreator.this.selectedF = null;
                    MapCreator.this.selectedF = (SimpleFeature)result.features().next();
                    String paramvalue = String.valueOf((double)Math.round((Double)MapCreator.this.selectedF.getAttribute("newAt") * 100.0) / 100.0);
                    String infoTxt = "<html><center><b>HRU-ID:</b><br>" + MapCreator.this.selectedF.getIdentifier() + "<br><b>" + MapCreator.this.mc[MapCreator.this.infoidx].getDesc() + ":</b><br>" + paramvalue + "</center></html>";
                    MapCreator.this.info.setText(infoTxt);
                    try {
                        MapCreator.this.topmap.removeLayer((MapLayer)MapCreator.this.selection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MapCreator.this.selection = new DefaultMapLayer(result, this.createFromSLD(MapCreator.this.getModel().getWorkspaceDirectory().getPath() + "/" + MapCreator.this.stylesFileName.getValue()), "selection");
                    MapCreator.this.topmap.addLayer(1, (MapLayer)MapCreator.this.selection);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "No attribute layer selected!");
                }
            }
        }
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon iconProject = null;
        private ImageIcon iconRange = null;
        private Icon blatt;
        private Icon blatt2;

        public NodeRenderer() {
            this.iconProject = new ImageIcon(MapCreator.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/root.png"));
            this.iconRange = new ImageIcon(MapCreator.this.getModel().getRuntime().getClassLoader().getResource("jams/components/gui/resources/map.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            DefaultMutableTreeNode parentnode = (DefaultMutableTreeNode)node.getParent();
            int idxToParentNode = 0;
            int idxToTopNode = 0;
            if (!node.isRoot()) {
                idxToParentNode = parentnode.getIndex(node);
                idxToTopNode = MapCreator.this.top.getIndex(parentnode);
            }
            if (node.isRoot()) {
                this.setIcon(this.iconProject);
            }
            if (!leaf && !node.isRoot()) {
                this.setIcon(this.iconRange);
            }
            if (leaf && node.getParent() == MapCreator.this.top) {
                this.blatt2 = new MyLayerIcon(MapCreator.this.top.getIndex(node));
                this.setIcon(this.blatt2);
            } else if (leaf) {
                this.blatt = new MyIcon(idxToTopNode, idxToParentNode);
                this.setIcon(this.blatt);
            }
            return this;
        }
    }

    class MyIcon
    implements Icon,
    Serializable {
        private Integer a;
        private Integer b;

        public MyIcon(Integer a, Integer b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (MapCreator.this.finished) {
                g.drawRect(1, 1, 19, 14);
                g.setColor(Color.BLACK);
                if (MapCreator.this.mc[this.a].getRanges().length - this.b - 1 >= 0) {
                    g.setColor((Color)MapCreator.this.mc[this.a].getColors()[MapCreator.this.mc[this.a].getRanges().length - this.b - 1]);
                }
                g.fillRect(1, 1, 19, 14);
            } else {
                MapCreator.this.tree.setVisible(false);
            }
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }

    class MyLayerIcon
    implements Icon {
        private int idx;

        public MyLayerIcon(Integer idx) {
            this.idx = idx - MapCreator.this.numOfParams;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.BLACK);
            g2d.drawRoundRect(0, 0, 20, 13, 5, 5);
            String geoType = ((SimpleFeatureType)MapCreator.this.optLayers[this.idx].getFeatureSource().getSchema()).getGeometryDescriptor().getType().getName().toString();
            g2d.setColor(Color.decode("#" + MapCreator.this.shapeColors.getValue()[this.idx]));
            if (geoType.equals("LineString") || geoType.equals("MultiLineString")) {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(4, 4, 13, 6);
                g2d.drawLine(13, 6, 15, 9);
            } else if (geoType.equals("Point") || geoType.equals("MultiPoint")) {
                g2d.fillRect(4, 4, 4, 4);
                g2d.fillRect(13, 6, 4, 4);
            } else if (geoType.equals("Polygon") || geoType.equals("MultiPolygon")) {
                int[] xPoints = new int[]{2, 5, 9, 17};
                int[] yPoints = new int[]{3, 10, 12, 2};
                g2d.fillPolygon(xPoints, yPoints, 4);
            }
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }
}

