/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import jams.components.gui.MapLegend;
import java.util.Map;
import java.util.TreeSet;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.styling.Style;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapCollection {
    private String desc;
    private FeatureCollection<SimpleFeatureType, SimpleFeature> fc;
    private TreeSet<Double> s;
    private DefaultMapContext map;
    private Style st;
    private Map colors;
    private String rangeColor;
    private int numRanges;
    private CollectionDataStore cds;
    private String attributeName;

    public MapCollection(String desc, FeatureCollection<SimpleFeatureType, SimpleFeature> fc, String attibuteName, String color, int numRanges, CoordinateReferenceSystem crs) {
        this.desc = desc;
        this.fc = fc;
        this.attributeName = attibuteName;
        this.s = this.buildValueSet(fc, attibuteName);
        this.st = null;
        this.map = new DefaultMapContext(crs);
        this.rangeColor = color;
        this.numRanges = numRanges;
        this.cds = new CollectionDataStore(this.fc);
        Map a = MapLegend.coloring(this.s, this.numRanges, this.rangeColor);
        this.st = MapLegend.style;
        this.colors = a;
        DefaultMapLayer layer = new DefaultMapLayer(this.fc, this.st);
        this.map.addLayer((MapLayer)layer);
    }

    public void update() {
        TreeSet<Double> s2 = this.buildValueSet(this.fc, this.attributeName);
        if (s2.first() < this.s.first() || s2.last() > this.s.last()) {
            Map a;
            this.s.addAll(s2);
            this.colors = a = MapLegend.coloring(this.s, this.numRanges, this.rangeColor);
            this.st = MapLegend.style;
            for (MapLayer layer : this.map.getLayers()) {
                layer.setStyle(this.st);
            }
        }
    }

    private TreeSet<Double> buildValueSet(FeatureCollection<SimpleFeatureType, SimpleFeature> fc, String attibuteName) {
        TreeSet<Double> s = new TreeSet<Double>();
        FeatureIterator fi = fc.features();
        while (fi.hasNext()) {
            Feature f = fi.next();
            if (!(f instanceof SimpleFeature)) continue;
            SimpleFeature sf = (SimpleFeature)f;
            try {
                double value = (Double)sf.getAttribute(attibuteName);
                s.add(value);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return s;
    }

    public String getDesc() {
        return this.desc;
    }

    public DefaultMapContext getMapContext() {
        return this.map;
    }

    public Object[] getRanges() {
        return this.colors.values().toArray();
    }

    public Object[] getColors() {
        return this.colors.keySet().toArray();
    }

    public CollectionDataStore asCollectionDataStore() {
        return this.cds;
    }

    public Style getStyle() {
        return this.st;
    }
}

