/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSGUIComponent;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.runtime.JAMSRuntime;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicProgressBarUI;

@JAMSComponentDescription(title="JAMS execution info frame", author="Sven Kralisch", date="2015-02-19", description="This visual component creates a panel with progress bar and log information", version="1.1_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2006-06-17", comment="Initial version"), @VersionComments.Entry(version="1.1_0", date="2015-02-19", comment="- Added output of estimated / recent runtime\n- Uses getModel().getProgress() now, allowing for a more precise runtime estimation\n- Can be used outside iteration context, causing smaller runtime footprint")})
public class JAMSExecInfo
extends JAMSGUIComponent
implements Serializable {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Update inteval", defaultValue="10")
    public Attribute.Integer milliSeconds;
    private JProgressBar jamsProgressBar;
    private JPanel progressPanel;
    private transient Runnable updatePBar;
    private transient Observer infoLogObserver;
    private transient Observer errorLogObserver;
    private JScrollPane scrollPanel;
    private JTextArea logArea;
    private JPanel panel;
    private long startTime;
    private transient ScheduledExecutorService exec;
    private boolean runonce = false;
    private JAMSRuntime rt;
    private double divisor = 1.0;

    public JPanel getPanel() {
        if (this.panel == null) {
            this.createPanel();
        }
        return this.panel;
    }

    public void init() {
        if (this.panel != null) {
            long max = this.getContext().getNumberOfIterations();
            this.divisor = Math.max(0L, max / Integer.MAX_VALUE) + 1L;
            this.jamsProgressBar.setMaximum((int)((double)max / this.divisor));
        } else {
            this.updatePBar = new Runnable(){

                @Override
                public void run() {
                }
            };
        }
        this.startTime = System.currentTimeMillis();
    }

    public void initAll() {
        if (!this.runonce && this.panel != null) {
            long max = this.getModel().getProgress()[1];
            this.divisor = Math.max(0L, max / Integer.MAX_VALUE) + 1L;
            this.jamsProgressBar.setMaximum((int)((double)max / this.divisor));
            this.rt = this.getModel().getRuntime();
            this.runonce = true;
        }
    }

    private void createObserver() {
        if (this.infoLogObserver == null) {
            this.infoLogObserver = new Observer(){

                @Override
                public void update(Observable obs, Object obj) {
                    JAMSExecInfo.this.logArea.append(obj.toString());
                }
            };
        }
        if (this.errorLogObserver == null) {
            this.errorLogObserver = new Observer(){

                @Override
                public void update(Observable obs, Object obj) {
                    JAMSExecInfo.this.logArea.append(obj.toString());
                }
            };
        }
    }

    private void createPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.jamsProgressBar = new JProgressBar();
        this.jamsProgressBar.setMinimum(0);
        this.jamsProgressBar.setString("Execution progress");
        this.jamsProgressBar.setStringPainted(true);
        this.jamsProgressBar.setIndeterminate(false);
        this.jamsProgressBar.setFont(Font.decode("Monospaced"));
        if (this.milliSeconds.getValue() == 101) {
            this.milliSeconds.setValue(20);
            this.jamsProgressBar.setUI(new CatProgressUI());
        }
        if (this.milliSeconds.getValue() == 7) {
            this.jamsProgressBar.setBackground(Color.darkGray);
            this.milliSeconds.setValue(20);
            this.jamsProgressBar.setUI(new PacmanProgressUI());
        }
        if (this.milliSeconds.getValue() == 42) {
            this.jamsProgressBar.setBackground(Color.darkGray);
            this.jamsProgressBar.setForeground(Color.lightGray);
            this.milliSeconds.setValue(20);
            this.jamsProgressBar.setUI(new GhostProgressUI());
        }
        this.updatePBar = new Runnable(){

            @Override
            public void run() {
                if (JAMSExecInfo.this.runonce && JAMSExecInfo.this.rt.getState() != 1) {
                    JAMSExecInfo.this.exec.shutdown();
                    return;
                }
                JAMSExecInfo.this.jamsProgressBar.setValue((int)((double)JAMSExecInfo.this.getModel().getProgress()[0] / JAMSExecInfo.this.divisor));
                long eTime = System.currentTimeMillis() - JAMSExecInfo.this.startTime;
                double progress = JAMSExecInfo.this.jamsProgressBar.getPercentComplete();
                long rTime = progress > 0.0 ? Math.round((double)eTime / progress) - eTime : 0L;
                String s = JAMSExecInfo.this.getTimeString(rTime, eTime);
                JAMSExecInfo.this.jamsProgressBar.setString(s);
            }
        };
        this.exec = Executors.newSingleThreadScheduledExecutor();
        this.exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(JAMSExecInfo.this.updatePBar);
            }
        }, 0L, this.milliSeconds.getValue(), TimeUnit.MILLISECONDS);
        this.progressPanel.add((Component)this.jamsProgressBar, "Center");
        this.progressPanel.setPreferredSize(new Dimension(0, 40));
        this.panel.add((Component)this.progressPanel, "North");
        this.scrollPanel = new JScrollPane();
        this.logArea = new JTextArea();
        this.logArea.setColumns(20);
        this.logArea.setRows(5);
        this.logArea.setLineWrap(false);
        this.logArea.setEditable(false);
        this.logArea.setFont(JAMS.STANDARD_FONT);
        this.scrollPanel.setViewportView(this.logArea);
        this.panel.add((Component)this.scrollPanel, "Center");
        this.logArea.append(this.getModel().getRuntime().getInfoLog());
        this.logArea.append(this.getModel().getRuntime().getErrorLog());
        this.createObserver();
        this.getModel().getRuntime().addInfoLogObserver(this.infoLogObserver);
        this.getModel().getRuntime().addErrorLogObserver(this.errorLogObserver);
    }

    private String getTimeString(long rTime, long eTime) {
        return String.format("%3.0f%% [%02d:%02d:%02d]/[%02d:%02d:%02d]", this.jamsProgressBar.getPercentComplete() * 100.0, eTime / 3600000L, eTime % 3600000L / 60000L, eTime % 60000L / 1000L, rTime / 3600000L, rTime % 3600000L / 60000L, rTime % 60000L / 1000L);
    }

    public void run() {
    }

    public void cleanup() {
        this.updatePBar.run();
    }

    public void restore() {
        this.updatePBar = new Runnable(){

            @Override
            public void run() {
                if (JAMSExecInfo.this.runonce && JAMSExecInfo.this.rt.getState() != 1) {
                    JAMSExecInfo.this.exec.shutdown();
                    return;
                }
                JAMSExecInfo.this.jamsProgressBar.setValue((int)((double)JAMSExecInfo.this.getModel().getProgress()[0] / JAMSExecInfo.this.divisor));
                long eTime = System.currentTimeMillis() - JAMSExecInfo.this.startTime;
                double progress = JAMSExecInfo.this.jamsProgressBar.getPercentComplete();
                long rTime = progress > 0.0 ? Math.round((double)eTime / progress) - eTime : 0L;
                String s = JAMSExecInfo.this.getTimeString(rTime, eTime);
                JAMSExecInfo.this.jamsProgressBar.setString(s);
            }
        };
        this.exec = Executors.newSingleThreadScheduledExecutor();
        this.exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(JAMSExecInfo.this.updatePBar);
            }
        }, 0L, this.milliSeconds.getValue(), TimeUnit.MILLISECONDS);
        if (this.logArea != null) {
            this.createObserver();
            this.getModel().getRuntime().addInfoLogObserver(this.infoLogObserver);
            this.getModel().getRuntime().addErrorLogObserver(this.errorLogObserver);
        }
    }

    private class GhostProgressUI
    extends BasicProgressBarUI {
        private int range = -20;
        private int count = 0;
        private int i = 1;
        private long max;

        public GhostProgressUI() {
            this.max = Math.max(1, Math.round(100 / JAMSExecInfo.this.milliSeconds.getValue()));
        }

        @Override
        protected void paintDeterminate(Graphics g, JComponent c) {
            super.paintDeterminate(g, c);
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Insets b = this.progressBar.getInsets();
            int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
            int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
            if (barRectWidth <= 0 || barRectHeight <= 0) {
                return;
            }
            int cellLength = this.getCellLength();
            int cellSpacing = this.getCellSpacing();
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.progressBar.getForeground());
            if (cellSpacing == 0 && amountFull > 0) {
                g2.setStroke(new BasicStroke(barRectHeight, 0, 2));
            } else {
                g2.setStroke(new BasicStroke(barRectHeight, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f));
            }
            g2.drawLine(b.left, barRectHeight / 2 + b.top, amountFull + b.left, barRectHeight / 2 + b.top);
            if (this.count == this.range) {
                this.i = 1;
            }
            if (this.count == 0) {
                this.i = -1;
            }
            this.count += this.i;
            try {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("jams/components/gui/resources/ghosts.png");
                BufferedImage image = ImageIO.read(is);
                g2.drawImage((Image)image, b.left + this.count, b.top + 3, null);
            }
            catch (IOException ex) {
                Logger.getLogger(CatProgressUI.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }

        @Override
        protected Color getSelectionForeground() {
            return Color.BLACK;
        }

        @Override
        protected Color getSelectionBackground() {
            return Color.WHITE;
        }
    }

    private class PacmanProgressUI
    extends BasicProgressBarUI {
        private String[] pacman = new String[]{"0", "1"};
        private int c1 = 0;
        private int c2 = 0;
        private long max;

        public PacmanProgressUI() {
            this.max = Math.max(1, Math.round(100 / JAMSExecInfo.this.milliSeconds.getValue()));
        }

        @Override
        protected void paintDeterminate(Graphics g, JComponent c) {
            BufferedImage image;
            InputStream is;
            super.paintDeterminate(g, c);
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Insets b = this.progressBar.getInsets();
            int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
            int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
            if (barRectWidth <= 0 || barRectHeight <= 0) {
                return;
            }
            int cellLength = this.getCellLength();
            int cellSpacing = this.getCellSpacing();
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.progressBar.getForeground());
            try {
                is = this.getClass().getClassLoader().getResourceAsStream("jams/components/gui/resources/fruits.png");
                image = ImageIO.read(is);
                g2.drawImage((Image)image, b.left, b.top + 8, null);
            }
            catch (IOException ex) {
                Logger.getLogger(CatProgressUI.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (cellSpacing == 0 && amountFull > 0) {
                g2.setStroke(new BasicStroke(barRectHeight, 0, 2));
            } else {
                g2.setStroke(new BasicStroke(barRectHeight, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f));
            }
            g2.drawLine(b.left, barRectHeight / 2 + b.top, amountFull + 18 + b.left, barRectHeight / 2 + b.top);
            ++this.c1;
            if ((long)this.c1 > this.max) {
                ++this.c2;
                this.c1 = 0;
            }
            try {
                is = this.getClass().getClassLoader().getResourceAsStream("jams/components/gui/resources/pacman" + this.pacman[this.c2 % 2] + ".png");
                image = ImageIO.read(is);
                g2.drawImage((Image)image, amountFull + b.left + 1, b.top, null);
            }
            catch (IOException ex) {
                Logger.getLogger(CatProgressUI.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }
    }

    private static class CatProgressUI
    extends BasicProgressBarUI {
        String cat = Math.random() >= 0.5 ? "1" : "2";

        @Override
        protected void paintDeterminate(Graphics g, JComponent c) {
            super.paintDeterminate(g, c);
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Insets b = this.progressBar.getInsets();
            int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
            int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
            if (barRectWidth <= 0 || barRectHeight <= 0) {
                return;
            }
            int cellLength = this.getCellLength();
            int cellSpacing = this.getCellSpacing();
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.progressBar.getForeground());
            if (cellSpacing == 0 && amountFull > 0) {
                g2.setStroke(new BasicStroke(barRectHeight, 0, 2));
            } else {
                g2.setStroke(new BasicStroke(barRectHeight, 0, 2, 0.0f, new float[]{cellLength, cellSpacing}, 0.0f));
            }
            g2.drawLine(b.left, barRectHeight / 2 + b.top, amountFull + b.left, barRectHeight / 2 + b.top);
            if (this.progressBar.getPercentComplete() == 1.0) {
                try {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("jams/components/gui/resources/cat" + this.cat + ".png");
                    BufferedImage image = ImageIO.read(is);
                    g2.drawImage((Image)image, amountFull + b.left - 60, 15, null);
                }
                catch (IOException ex) {
                    Logger.getLogger(CatProgressUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                try {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("jams/components/gui/resources/cat.png");
                    BufferedImage image = ImageIO.read(is);
                    g2.drawImage((Image)image, amountFull + b.left - 30, 15, null);
                }
                catch (IOException ex) {
                    Logger.getLogger(CatProgressUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }
    }
}

