/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSGUIComponent;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

@JAMSComponentDescription(title="Category plot", author="Sven Kralisch", date="2017-06-30", description="This component creates a graphical plot of category data, e.g. to compare attributes of different model entities.", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2017-06-30", comment="Initial version")})
public class CategoryPlot
extends JAMSGUIComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for plot. Default: component name")
    public Attribute.String plotTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Static title strings for graphs. Number of entries must be identical to number of plottet values.", defaultValue="title")
    public Attribute.StringArray graphTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Colors for left graphs (yellow, orange, red, pink, magenta, cyan, yellow, green, lightgray, gray, black). Number of entries must be identical to number of plottet values (valueLeft).", defaultValue="blue;red")
    public Attribute.StringArray colors;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Values for row/columns combinations to be plotted")
    public Attribute.Double[] values;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Row keys")
    public Attribute.String[] rowKeys;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Column keys")
    public Attribute.String[] columnKeys;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for x axis", defaultValue="")
    public Attribute.String xAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for y-axis", defaultValue="yAxisTitle")
    public Attribute.String yAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Create a vertical plot? Otherwise it will be horizontal.", defaultValue="true")
    public Attribute.Boolean plotVertical;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Plot the data in cleanup stage? If not, data are plotted in run stage.", defaultValue="false")
    public Attribute.Boolean plotInCleanup;
    HashMap<String, Color> colorTable = new HashMap();
    transient CategoryDataset dataset;
    transient JFreeChart chart;
    ChartPanel chartPanel;
    JPanel panel;

    public CategoryPlot() {
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
    }

    public JPanel getPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        return this.panel;
    }

    public void init() {
    }

    public void run() {
        if (!this.plotInCleanup.getValue()) {
            this.plotData();
        }
    }

    public void cleanup() {
        if (this.plotInCleanup.getValue()) {
            this.plotData();
        }
    }

    private void plotData() {
        if (this.panel == null) {
            return;
        }
        this.dataset = this.createDataset();
        String title = this.getInstanceName();
        if (this.plotTitle != null) {
            title = this.plotTitle.getValue();
        }
        PlotOrientation po = this.plotVertical.getValue() ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
        this.chart = ChartFactory.createBarChart((String)title, (String)this.xAxisTitle.getValue(), (String)this.yAxisTitle.getValue(), (CategoryDataset)this.dataset, (PlotOrientation)po, (boolean)true, (boolean)true, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.panel.add((Component)this.chartPanel, "Center");
        this.panel.updateUI();
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < this.values.length; ++i) {
            double value = this.values[i].getValue();
            String col = this.columnKeys[i].getValue();
            String row = this.rowKeys[i].getValue();
            dataset.addValue(value, (Comparable)((Object)row), (Comparable)((Object)col));
        }
        return dataset;
    }

    private CategoryDataset createExampleDataset() {
        String fiat = "FIAT";
        String audi = "AUDI";
        String ford = "FORD";
        String speed = "Speed";
        String millage = "Millage";
        String userrating = "User Rating";
        String safety = "safety";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"FIAT"), (Comparable)((Object)"Speed"));
        dataset.addValue(3.0, (Comparable)((Object)"FIAT"), (Comparable)((Object)"User Rating"));
        dataset.addValue(5.0, (Comparable)((Object)"FIAT"), (Comparable)((Object)"Millage"));
        dataset.addValue(5.0, (Comparable)((Object)"FIAT"), (Comparable)((Object)"safety"));
        dataset.addValue(5.0, (Comparable)((Object)"AUDI"), (Comparable)((Object)"Speed"));
        dataset.addValue(6.0, (Comparable)((Object)"AUDI"), (Comparable)((Object)"User Rating"));
        dataset.addValue(4.0, (Comparable)((Object)"AUDI"), (Comparable)((Object)"safety"));
        dataset.addValue(4.0, (Comparable)((Object)"FORD"), (Comparable)((Object)"Speed"));
        dataset.addValue(2.0, (Comparable)((Object)"FORD"), (Comparable)((Object)"User Rating"));
        dataset.addValue(3.0, (Comparable)((Object)"FORD"), (Comparable)((Object)"Millage"));
        return dataset;
    }
}

