/*
 * Decompiled with CFR 0.152.
 */
package jams.components.datatransfer;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="ArrayExtractor", author="Sven Kralisch", description="Component for converting Attribute.DoubleArray to Attribute.Double[], this way allowing to access the double values stored in a Attribute.DoubleArray directly within a JAMS model.", version="1.0_0", date="2006-02-23")
public class ArrayExtractor
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Double attributes to be set")
    public Attribute.DoubleArray in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Double value")
    public Attribute.Double[] out;

    public void run() {
        int max = Math.min(this.out.length, this.in.getValue().length);
        double[] array = this.in.getValue();
        for (int i = 0; i < max; ++i) {
            if (i >= array.length) continue;
            this.out[i].setValue(array[i]);
        }
    }
}

