/*
 * Decompiled with CFR 0.152.
 */
package jams.components.data;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="ScalarToArray", author="Sven Kralisch", description="Collect double scalar(s) into double array(s)", date="2019-11-06", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class ScalarToArray
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="input value(s)")
    public Attribute.Double[] dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="array(s) of values")
    public Attribute.DoubleArray[] dataArray;

    public void init() {
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.dataArray[i].getValue() != null) continue;
            this.dataArray[i].setValue(new double[0]);
        }
    }

    public void run() {
        for (int i = 0; i < this.dataValue.length; ++i) {
            if (this.dataArray[i].getValue() == null) {
                this.dataArray[i].setValue(new double[0]);
            }
            double[] a = this.dataArray[i].getValue();
            double[] b = new double[a.length + 1];
            System.arraycopy(a, 0, b, 0, a.length);
            b[b.length - 1] = this.dataValue[i].getValue();
            this.dataArray[i].setValue(b);
        }
    }
}

