/*
 * Decompiled with CFR 0.152.
 */
package jams.components.data;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="EntityDoubleAccess", author="Sven Kralisch", description="Get double values by name from an entity and store it in attributes.", date="2023-06-13", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class EntityDoubleAccess
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The entity collection")
    public Attribute.Entity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Names of the entitiy attributes to access")
    public Attribute.String[] names;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The target attributes, number must match that of names")
    public Attribute.Double[] attributes;

    public void run() {
        if (!this.entity.isEmpty()) {
            int i = 0;
            for (Attribute.String name : this.names) {
                this.attributes[i].setValue(this.entity.getDouble(name.getValue()));
                ++i;
            }
        }
    }
}

