/*
 * Decompiled with CFR 0.152.
 */
package jams.components.data;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="CalendarComponentChanged", author="Sven Kralisch", description="Checks whether there is a change in a given component of a calendar object", date="2020-03-18", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class CalendarComponentChanged
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the input date/time")
    public Attribute.Calendar dateTime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of the date/time component to be checked\n(year:1, month:2, week_of_year:3, day_of_year:6, day_of_month:5, day_of_week:7")
    public Attribute.Integer componentID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="result indicating whether the date/time component has changed or not")
    public Attribute.Boolean changed;
    private int old = Integer.MIN_VALUE;

    public void run() {
        int current = this.dateTime.get(this.componentID.getValue());
        if (current != this.old) {
            this.old = current;
            this.changed.setValue(true);
        } else {
            this.changed.setValue(false);
        }
    }
}

