/*
 * Decompiled with CFR 0.152.
 */
package jams.components.data;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="ArrayToScalar", author="Sven Kralisch", description="Extracts single scalar doubles from an array of double values", date="2020-09-03", version="1.0_3")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Extended to handle multiple values"), @VersionComments.Entry(version="1.0_2", comment="Extended to allow iteration over indices/dataArrays"), @VersionComments.Entry(version="1.0_3", comment="Extended to allow iteration be enabled/disabled")})
public class ArrayToScalar
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of values to extract from")
    public Attribute.DoubleArray[] dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the index of the value to be extracted")
    public Attribute.Integer[] arrayIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="optional correction factor", defaultValue="1")
    public Attribute.Double factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="iterate through array?", defaultValue="false")
    public Attribute.Boolean iterate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="extracted value")
    public Attribute.Double[] dataValue;

    public void run() {
        int i;
        for (i = 0; i < this.arrayIndex.length; ++i) {
            if (this.arrayIndex[i].getValue() == -1 || this.arrayIndex[i].getValue() >= this.dataArray[i].getValue().length) continue;
            this.dataValue[i].setValue(this.dataArray[i].getValue()[this.arrayIndex[i].getValue()] * this.factor.getValue());
        }
        if (this.iterate.getValue()) {
            for (i = 0; i < this.arrayIndex.length; ++i) {
                this.arrayIndex[i].setValue(this.arrayIndex[i].getValue() + 1);
            }
        }
    }
}

